/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.pipelines.graph;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.pipelines.graph.GraphPipeline;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeCache;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class GraphPipelineRegistry
implements Serializable {
    private static final long serialVersionUID = 4352452831967867958L;
    private static final Logger logger = Logger.getLogger(GraphPipelineRegistry.class);
    private final Map<Class<? extends IAnnotation>, Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>>> registry;
    private final ConcurrentMap<Class<? extends IAnnotation>, Set<Class<? extends IValuedAnnotation<?>>>> requiredOptionsCache;
    private transient PipelineNodeCache pipelineNodeCache;

    public GraphPipelineRegistry(Configuration configuration) {
        this(GraphPipelineRegistry.copyRegistry(configuration));
    }

    private static Map<Class<? extends IAnnotation>, Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>>> copyRegistry(Configuration configuration) {
        HashMap registry = new HashMap();
        for (Map.Entry entry : configuration.registry.entrySet()) {
            registry.put((Class<IAnnotation>)entry.getKey(), (Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>>)new HashMap((Map)entry.getValue()));
        }
        return registry;
    }

    private GraphPipelineRegistry(Map<Class<? extends IAnnotation>, Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>>> registry) {
        this.registry = registry;
        this.requiredOptionsCache = new ConcurrentHashMap();
        this.pipelineNodeCache = new PipelineNodeCache();
    }

    public GraphPipeline getPipeline(PipelineSpecification specification) {
        return new GraphPipeline(this, specification);
    }

    Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptionTypes(Class<? extends IAnnotation> annotationType) {
        Set<Class<? extends IValuedAnnotation<?>>> result = (Set<Class<? extends IValuedAnnotation<?>>>)this.requiredOptionsCache.get(annotationType);
        if (result == null) {
            result = this.computeRequiredOptionTypes(annotationType);
            this.requiredOptionsCache.put(annotationType, result);
        }
        return result;
    }

    private Set<Class<? extends IValuedAnnotation<?>>> computeRequiredOptionTypes(Class<? extends IAnnotation> annotationType) {
        Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> annotationRegistry = this.getAnnotationRegistry(annotationType);
        HashSet result = new HashSet();
        for (NLPDocumentOptions settedOptions : annotationRegistry.keySet()) {
            result.addAll(settedOptions.getSpecifiedOptionTypes());
        }
        return result;
    }

    <A extends IAnnotation> IPipelineNodeProvider<A, IAnnotator<A>> getPipelineNodeProvider(Class<? extends A> annotationType, NLPDocumentOptions requiredOptions) {
        Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> annotationRegistry = this.getAnnotationRegistry(annotationType);
        HashSet mostSpecifiedApplicableProviders = new HashSet();
        int maxExactMatchings = 0;
        for (Map.Entry<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> entry : annotationRegistry.entrySet()) {
            int exactMatchings = this.getOptionsExactMatchings(entry.getKey(), requiredOptions);
            if (exactMatchings == maxExactMatchings) {
                mostSpecifiedApplicableProviders.add(entry.getValue());
                continue;
            }
            if (exactMatchings <= maxExactMatchings) continue;
            maxExactMatchings = exactMatchings;
            mostSpecifiedApplicableProviders.clear();
            mostSpecifiedApplicableProviders.add(entry.getValue());
        }
        if (mostSpecifiedApplicableProviders.size() != 1) {
            throw new TexterraSystemException(String.format("For %s annotation type there isn't exact one applicable pipeline node provider in registry for %s document options. Applicable pipeline node providers: %s.", annotationType, requiredOptions, mostSpecifiedApplicableProviders));
        }
        return (IPipelineNodeProvider)mostSpecifiedApplicableProviders.iterator().next();
    }

    private int getOptionsExactMatchings(NLPDocumentOptions required, NLPDocumentOptions actual) {
        if (!actual.matches(required)) {
            return -1;
        }
        return required.getSpecifiedOptionTypes().size();
    }

    private Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> getAnnotationRegistry(Class<? extends IAnnotation> annotationType) {
        Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> annotationRegistry = this.registry.get(annotationType);
        if (annotationRegistry == null) {
            throw new TexterraSystemException(String.format("There are no specified pipeline node providers for %s annotation type", annotationType));
        }
        return annotationRegistry;
    }

    <A extends IAnnotation, T extends IAnnotator<A>> PipelineNode<A, T> getCachedPipelineNode(IPipelineNodeProvider<A, T> pipelineNodeProvider, NLPDocumentOptions requiredOptions) {
        return this.pipelineNodeCache.getCachedPipelineNode(pipelineNodeProvider, requiredOptions);
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.pipelineNodeCache = new PipelineNodeCache();
    }

    public static final class PipelineSpecification
    implements Serializable {
        private static final long serialVersionUID = -1077432538675086338L;
        private final IDocumentFactory documentFactory;
        private final PipelineNodeDependencies targets;
        private final NLPDocumentOptions knownOptions;
        private final Set<Class<? extends IAnnotation>> inputs;

        private PipelineSpecification(IDocumentFactory documentFactory, PipelineNodeDependencies targets, NLPDocumentOptions knownOptions, Set<Class<? extends IAnnotation>> inputs) {
            this.documentFactory = documentFactory;
            this.targets = targets;
            this.knownOptions = knownOptions;
            this.inputs = inputs;
        }

        public PipelineSpecification(IDocumentFactory documentFactory) {
            this(documentFactory, new PipelineNodeDependencies(), new NLPDocumentOptions(), (Set<Class<? extends IAnnotation>>)ImmutableSet.of());
        }

        public PipelineSpecification() {
            this(null);
        }

        public IDocumentFactory getDocumentFactory() {
            if (this.documentFactory == null) {
                throw new NoSuchElementException();
            }
            return this.documentFactory;
        }

        public boolean shouldPreserveInputDocumentFactory() {
            return this.documentFactory == null;
        }

        protected PipelineNodeDependencies getTargets() {
            return this.targets;
        }

        public PipelineSpecification withTargets(Collection<Class<? extends IAnnotation>> targets) {
            return this.withSoftImplicitTargets(targets);
        }

        @SafeVarargs
        public final PipelineSpecification withTargets(Class<? extends IAnnotation> ... targets) {
            return this.withSoftImplicitTargets(targets);
        }

        public PipelineSpecification withSoftImplicitTargets(Collection<Class<? extends IAnnotation>> targets) {
            return new PipelineSpecification(this.documentFactory, this.targets.withSoftImplicitDependencies(targets), this.knownOptions, this.inputs);
        }

        @SafeVarargs
        public final PipelineSpecification withSoftImplicitTargets(Class<? extends IAnnotation> ... targets) {
            return this.withSoftImplicitTargets(Arrays.asList(targets));
        }

        public PipelineSpecification withSoftExplicitTargets(Collection<? extends IPipelineNodeProvider<?, ?>> targets) {
            return new PipelineSpecification(this.documentFactory, this.targets.withSoftExplicitDependencies(targets), this.knownOptions, this.inputs);
        }

        public PipelineSpecification withSoftExplicitTargets(IPipelineNodeProvider<?, ?> ... targets) {
            return this.withSoftExplicitTargets(Arrays.asList(targets));
        }

        public PipelineSpecification withHardTargets(Collection<PipelineNode<?, ?>> targets) {
            return new PipelineSpecification(this.documentFactory, this.targets.withHardDependencies(targets), this.knownOptions, this.inputs);
        }

        public PipelineSpecification withHardTargets(PipelineNode<?, ?> ... targets) {
            return this.withHardTargets(Arrays.asList(targets));
        }

        public NLPDocumentOptions getKnownOptions() {
            return this.knownOptions;
        }

        public <T> PipelineSpecification withKnownOption(Class<? extends IValuedAnnotation<T>> type, T option) {
            return new PipelineSpecification(this.documentFactory, this.targets, this.knownOptions.withOption(type, option), this.inputs);
        }

        public PipelineSpecification withKnownOptions(NLPDocumentOptions options) {
            return new PipelineSpecification(this.documentFactory, this.targets, this.knownOptions.withOptions(options), this.inputs);
        }

        public Set<Class<? extends IAnnotation>> getInputs() {
            return this.inputs;
        }

        public PipelineSpecification withInputs(Collection<Class<? extends IAnnotation>> inputs) {
            return new PipelineSpecification(this.documentFactory, this.targets, this.knownOptions, (Set<Class<? extends IAnnotation>>)new ImmutableSet.Builder().addAll(this.inputs).addAll(inputs).build());
        }

        @SafeVarargs
        public final PipelineSpecification withInputs(Class<? extends IAnnotation> ... inputs) {
            return this.withInputs(Arrays.asList(inputs));
        }
    }

    public static interface IConfigurationModule {
        public void configure(Configuration var1);
    }

    public static final class Configuration {
        private final Map<Class<? extends IAnnotation>, Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>>> registry = new HashMap();

        public <A extends IAnnotation> Configuration register(Class<A> annotationType, NLPDocumentOptions options, IPipelineNodeProvider<A, ?> provider) {
            IPipelineNodeProvider<A, ?> oldProvider;
            Map<NLPDocumentOptions, IPipelineNodeProvider<?, ?>> annotationTypeRegistry = this.registry.get(annotationType);
            if (annotationTypeRegistry == null) {
                annotationTypeRegistry = new HashMap();
                this.registry.put(annotationType, annotationTypeRegistry);
            }
            if ((oldProvider = annotationTypeRegistry.put(options, provider)) != null) {
                logger.info((Object)String.format("Overriden %s by %s for [%s,%s].", oldProvider, provider, annotationType, options));
            }
            return this;
        }

        public Configuration register(IConfigurationModule ... modules) {
            for (IConfigurationModule module : modules) {
                module.configure(this);
            }
            return this;
        }
    }
}

