/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.modelsio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;

public final class PropertiesOptionsBasedModelsIO
extends AbstractOptionsBasedModelsIO<Properties>
implements Serializable {
    private static final long serialVersionUID = -7704002343459440731L;
    private final String modelName;

    public PropertiesOptionsBasedModelsIO(String modelName) {
        this.modelName = modelName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties load(NLPDocumentOptions options) {
        String modelsPath = this.getModelsPath(options);
        try (InputStreamReader in = new InputStreamReader(ClasspathUtils.getResourceAsStream((String)modelsPath, (String)this.modelName), StandardCharsets.UTF_8);){
            Properties result = new Properties();
            result.load(in);
            Properties properties = result;
            return properties;
        }
        catch (IOException e) {
            throw new TexterraConfigException(String.format("Can not load %s for %s NLP document options.", this.modelName, options), (Throwable)e);
        }
    }

    @Override
    public void save(NLPDocumentOptions options, Properties model) {
        String modelsPath = this.getSaveModelsPath(options);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(modelsPath, this.modelName)), StandardCharsets.UTF_8);){
            model.store(out, null);
        }
        catch (IOException e) {
            throw new TexterraConfigException(String.format("Can not save %s for %s NLP document options.", this.modelName, options), (Throwable)e);
        }
    }
}

