/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.datamodel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;

public final class NLPDocumentOptions
implements Serializable {
    private static final long serialVersionUID = 7531325630950634979L;
    private final Map<Class<? extends IValuedAnnotation<?>>, Object> options;

    public NLPDocumentOptions() {
        this.options = new HashMap();
    }

    private NLPDocumentOptions(Map<Class<? extends IValuedAnnotation<?>>, Object> options) {
        this.options = options;
    }

    public <T> NLPDocumentOptions withOption(Class<? extends IValuedAnnotation<T>> key, T option) {
        HashMap map = new HashMap(this.options);
        map.put(key, option);
        return new NLPDocumentOptions(map);
    }

    public NLPDocumentOptions withOption(IValuedAnnotation<?> optionAnnotation) {
        HashMap map = new HashMap(this.options);
        map.put(optionAnnotation.getClass(), optionAnnotation.getValue());
        return new NLPDocumentOptions(map);
    }

    public NLPDocumentOptions withOptions(NLPDocumentOptions other) {
        HashMap map = new HashMap(this.options);
        map.putAll(other.options);
        return new NLPDocumentOptions(map);
    }

    public boolean containsOption(Class<? extends IValuedAnnotation<?>> optionClass) {
        return this.options.containsKey(optionClass);
    }

    public <T> T getOption(Class<? extends IValuedAnnotation<T>> optionClass) {
        return (T)this.options.get(optionClass);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public NLPDocumentOptions filter(Set<Class<? extends IValuedAnnotation<?>>> optionTypes) {
        HashMap map = new HashMap(optionTypes.size());
        for (Class<IValuedAnnotation<?>> clazz : optionTypes) {
            Object optionValue = this.options.get(clazz);
            if (optionValue == null) continue;
            map.put(clazz, optionValue);
        }
        return new NLPDocumentOptions(map);
    }

    @SafeVarargs
    public final NLPDocumentOptions filter(Class<? extends IValuedAnnotation<?>> ... optionTypes) {
        return this.filter(new HashSet(Arrays.asList(optionTypes)));
    }

    public boolean matches(NLPDocumentOptions other) {
        for (Map.Entry<Class<IValuedAnnotation<?>>, Object> entry : other.options.entrySet()) {
            Object value = this.options.get(entry.getKey());
            if (entry.getValue().equals(value)) continue;
            return false;
        }
        return true;
    }

    public Set<Class<? extends IValuedAnnotation<?>>> getSpecifiedOptionTypes() {
        return this.options.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NLPDocumentOptions)) {
            return false;
        }
        NLPDocumentOptions other = (NLPDocumentOptions)obj;
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    public String toString() {
        return "NLPDocumentOptions [options=" + this.options + "]";
    }
}

