/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;

public interface ITexterraNLP {
    public INLPDocument traverse(INLPDocument var1, PipelineSpecification var2);

    public List<? extends INLPDocument> traverse(List<? extends INLPDocument> var1, PipelineSpecification var2);

    public static final class PipelineSpecification
    implements Serializable {
        private static final long serialVersionUID = 7028656418079455572L;
        private final Set<Class<? extends IAnnotation>> targets;
        private final NLPDocumentOptions knownOptions;
        private final Set<Class<? extends IAnnotation>> inputs;

        private PipelineSpecification(Set<Class<? extends IAnnotation>> targets, NLPDocumentOptions knownOptions, Set<Class<? extends IAnnotation>> inputs) {
            this.targets = targets;
            this.knownOptions = knownOptions;
            this.inputs = inputs;
        }

        public PipelineSpecification() {
            this((Set<Class<? extends IAnnotation>>)ImmutableSet.of(), new NLPDocumentOptions(), (Set<Class<? extends IAnnotation>>)ImmutableSet.of());
        }

        public Set<Class<? extends IAnnotation>> getTargets() {
            return this.targets;
        }

        public PipelineSpecification withTargets(Collection<Class<? extends IAnnotation>> targets) {
            return new PipelineSpecification((Set<Class<? extends IAnnotation>>)new ImmutableSet.Builder().addAll(this.targets).addAll(targets).build(), this.knownOptions, this.inputs);
        }

        @SafeVarargs
        public final PipelineSpecification withTargets(Class<? extends IAnnotation> ... targets) {
            return this.withTargets(Arrays.asList(targets));
        }

        public NLPDocumentOptions getKnownOptions() {
            return this.knownOptions;
        }

        public <T> PipelineSpecification withKnownOption(Class<? extends IValuedAnnotation<T>> type, T option) {
            return new PipelineSpecification(this.targets, this.knownOptions.withOption(type, option), this.inputs);
        }

        public PipelineSpecification withKnownOptions(NLPDocumentOptions options) {
            return new PipelineSpecification(this.targets, this.knownOptions.withOptions(options), this.inputs);
        }

        public Set<Class<? extends IAnnotation>> getInputs() {
            return this.inputs;
        }

        public PipelineSpecification withInputs(Collection<Class<? extends IAnnotation>> inputs) {
            return new PipelineSpecification(this.targets, this.knownOptions, (Set<Class<? extends IAnnotation>>)new ImmutableSet.Builder().addAll(this.inputs).addAll(inputs).build());
        }

        @SafeVarargs
        public final PipelineSpecification withInputs(Class<? extends IAnnotation> ... inputs) {
            return this.withInputs(Arrays.asList(inputs));
        }
    }
}

