/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.ispras.modis.utils.xml.ParserContext;
import ru.ispras.modis.utils.xml.XMLElementProcessor;

public class CommonXMLParser
extends DefaultHandler {
    protected XMLElementProcessor processor;
    protected final ParserContext context = new ParserContext();
    protected Map<String, XMLElementProcessor> processorMap = new HashMap<String, XMLElementProcessor>(32);

    public void parse(InputStream inputStream, SAXParserFactory sAXParserFactory) throws SAXException, IOException, ParserConfigurationException {
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.newSAXParser().parse(inputStream, (DefaultHandler)this);
    }

    public void add(String string, XMLElementProcessor xMLElementProcessor) {
        this.processorMap.put(string, xMLElementProcessor);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (this.processor != null) {
            this.processor.characters(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        this.context.elementStack.pop();
        if (this.processor != null) {
            this.processor = this.processor.endElement(string2.intern());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.processor != null) {
            this.processor = this.processor.startElement(string2.intern(), attributes);
        } else {
            this.processor = this.processorMap.get(string2);
            if (this.processor != null) {
                this.processor.createElement(null, string2.intern(), attributes, this.context);
            }
        }
        this.context.elementStack.push(string2.intern());
    }
}

