/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.objectspool;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import ru.ispras.modis.utils.objectspool.IObjectsPool;
import ru.ispras.modis.utils.objectspool.IPoolObjectsFactory;
import ru.ispras.modis.utils.objectspool.NotPooledObjectException;

public class FixedSizeObjectsPool<T>
implements IObjectsPool<T> {
    private IPoolObjectsFactory<T> factory;
    private BlockingQueue<T> pooledObjects;
    private Set<T> objects;
    private final Object lock = new Object();
    private int numCreated = 0;
    private final int maxSize;

    public FixedSizeObjectsPool(int n, int n2, IPoolObjectsFactory<T> iPoolObjectsFactory) {
        this.objects = new HashSet<T>(n2);
        this.maxSize = n2;
        this.pooledObjects = new ArrayBlockingQueue<T>(n2);
        this.factory = iPoolObjectsFactory;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            this.pooledObjects.add(this.createObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getObject() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            Object e = this.pooledObjects.poll();
            if (e != null) {
                return (T)e;
            }
            if (this.numCreated < this.maxSize) {
                return this.createObject();
            }
        }
        return this.pooledObjects.take();
    }

    private T createObject() {
        ++this.numCreated;
        T t = this.factory.createObject();
        this.objects.add(t);
        return t;
    }

    @Override
    public T borrowObject() throws InterruptedException {
        T t = this.getObject();
        this.factory.onBorrowObject(t);
        return t;
    }

    @Override
    public void returnObject(T t) {
        if (!this.objects.contains(t)) {
            throw new NotPooledObjectException("Object " + t + " was not borrowed from the pool!");
        }
        this.factory.onReturnObject(t);
        try {
            this.pooledObjects.put(t);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

