/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config.selectors;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.MultiSourceConfiguration;
import ru.ispras.modis.utils.config.selectors.ConfigFilesSelector;

public class ClasspathConfigFilesSelector
extends ConfigFilesSelector {
    private final String propertiesFile;

    public ClasspathConfigFilesSelector(String string) {
        this.propertiesFile = string;
    }

    @Override
    public List<URI> getURIs() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        URL uRL = ClasspathConfigFilesSelector.getResourceFromClasspath(this.propertiesFile);
        if (uRL != null) {
            try {
                arrayList.add(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger(MultiSourceConfiguration.class).warn((Object)"Default configuration file (from CLASSPATH) not found!", (Throwable)uRISyntaxException);
            }
        }
        return arrayList;
    }

    private static URL getResourceFromClasspath(String string) {
        return ClasspathUtils.getResource(string);
    }
}

