/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config.generate;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import ru.ispras.modis.utils.config.generate.Utils;

public class QuestionProcessor {
    private static final String MESSAGE = "message";
    private static final String PROPERTY = "property";
    private static final String IF = "if";
    private static final String ANSWER = "answer";
    private static final String VALID = "validanswer";
    private static final String ITEM = "item";
    private HierarchicalConfiguration configToUpdate;

    public QuestionProcessor(HierarchicalConfiguration hierarchicalConfiguration) {
        this.configToUpdate = hierarchicalConfiguration;
    }

    public void processQuestion(HierarchicalConfiguration hierarchicalConfiguration) throws IOException {
        String string;
        String string2 = hierarchicalConfiguration.getString(MESSAGE);
        List<String> list = Arrays.asList(hierarchicalConfiguration.getStringArray(PROPERTY));
        if (list.isEmpty()) {
            System.out.println("ERROR: No properties to update!");
            return;
        }
        String string3 = this.configToUpdate.getString(list.get(0));
        do {
            if ((string = Utils.readFromConsole(string2, string3, "Default: ")) != null) continue;
            throw new IOException("null instead of String received!");
        } while (!this.processAnswer(string, string3, hierarchicalConfiguration, list));
    }

    private boolean processAnswer(String string, String string2, HierarchicalConfiguration hierarchicalConfiguration, List<String> list) {
        String string3 = string = string.isEmpty() ? string2 : string;
        if (!this.isValidAnswer(string, hierarchicalConfiguration)) {
            System.out.println("Invalid answer!");
            System.out.println();
            return false;
        }
        System.out.println("Using value: " + string);
        for (String string4 : list) {
            this.configToUpdate.setProperty(string4, (Object)string);
        }
        this.postAnswerMessage(string, hierarchicalConfiguration);
        System.out.println();
        return true;
    }

    private void postAnswerMessage(String string, HierarchicalConfiguration hierarchicalConfiguration) {
        for (SubnodeConfiguration subnodeConfiguration : hierarchicalConfiguration.configurationsAt(IF)) {
            if (!subnodeConfiguration.getString(Utils.getAttribute(ANSWER)).equalsIgnoreCase(string)) continue;
            System.out.println(subnodeConfiguration.getString(""));
        }
    }

    private boolean isValidAnswer(String string, HierarchicalConfiguration hierarchicalConfiguration) {
        boolean bl = true;
        Iterator iterator = hierarchicalConfiguration.configurationsAt(VALID).iterator();
        while (iterator.hasNext()) {
            bl &= this.checkValidAnswer(string, (HierarchicalConfiguration)iterator.next());
        }
        return bl;
    }

    private boolean checkValidAnswer(String string, HierarchicalConfiguration hierarchicalConfiguration) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(hierarchicalConfiguration.getStringArray(ITEM)));
        return hashSet.contains(string);
    }
}

