/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.config;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

class AttributesFilteringIterator
implements Iterator<String> {
    private static final Pattern attributePattern = Pattern.compile("\\[@(?:((?!(?:\\]$)).)*)\\]$", 32);
    private Iterator<String> iter;
    private String next;

    public AttributesFilteringIterator(Iterator<String> iterator) {
        this.iter = iterator;
        this.next = this.getNextNonAttribute();
    }

    private String getNextNonAttribute() {
        while (this.iter.hasNext()) {
            String string = this.iter.next();
            if (this.isAttribute(string)) continue;
            return string;
        }
        return null;
    }

    private boolean isAttribute(String string) {
        return attributePattern.matcher(string).find();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        this.next = this.getNextNonAttribute();
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

