/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import ru.ispras.modis.utils.concurrent.FutureUtils;
import ru.ispras.modis.utils.concurrent.IItemsProcessor;

public class MultiThreadedTasksGroupProcessor {
    private final ExecutorService pool;

    public MultiThreadedTasksGroupProcessor(ExecutorService executorService) {
        this.pool = executorService;
    }

    public <T, R> Future<R> processTasksGroup(List<? extends Callable<T>> list, IItemsProcessor<T, R> iItemsProcessor) {
        ArrayList arrayList = new ArrayList(list.size());
        for (Callable<T> callable : list) {
            arrayList.add(this.pool.submit(callable));
        }
        return this.pool.submit(new ProcessTaskResultsTask(arrayList, iItemsProcessor));
    }

    private static class ProcessTaskResultsTask<T, R>
    implements Callable<R> {
        private List<Future<T>> pendingTasks;
        private IItemsProcessor<T, R> taskResultsProcessor;
        private R result;

        public ProcessTaskResultsTask(List<Future<T>> list, IItemsProcessor<T, R> iItemsProcessor) {
            this.pendingTasks = new ArrayList<Future<T>>(list);
            this.taskResultsProcessor = iItemsProcessor;
        }

        @Override
        public R call() throws Exception {
            if (this.pendingTasks != null) {
                List list = FutureUtils.getResults(this.pendingTasks);
                this.result = this.taskResultsProcessor.process(list);
                this.pendingTasks = null;
            }
            return this.result;
        }
    }
}

