/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TopWeightItemsCollection<T extends Serializable>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -3029693309833855467L;
    private static final double DEFAULT_WEIGHT = 1.0;
    private static final int DEFAULT_SIZE = 15;
    private final Map<T, Double> item2weight = new HashMap<T, Double>();
    private final double defaultWeight;
    private final int size;

    public TopWeightItemsCollection(int n, double d) {
        this.defaultWeight = d;
        this.size = n;
    }

    public TopWeightItemsCollection(int n) {
        this(n, 1.0);
    }

    public TopWeightItemsCollection() {
        this(15, 1.0);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return new ArrayList<T>(this.item2weight.keySet()).iterator();
    }

    public synchronized Map<T, Double> getWeightedItems() {
        return Collections.unmodifiableMap(this.item2weight);
    }

    public synchronized Map<T, Double> getWeightedItems(int n) {
        if (this.item2weight.size() <= n) {
            return this.getWeightedItems();
        }
        List<T> list = this.orderByWeight(this.item2weight);
        return this.collectItems(list.subList(0, n));
    }

    private Map<T, Double> collectItems(List<T> list) {
        HashMap<Serializable, Double> hashMap = new HashMap<Serializable, Double>();
        for (Serializable serializable : list) {
            hashMap.put(serializable, this.item2weight.get(serializable));
        }
        return hashMap;
    }

    public synchronized void add(Collection<T> collection) {
        this.add((T)collection, this.defaultWeight);
    }

    public synchronized void add(Collection<T> collection, double d) {
        this.addItems(collection, d);
        this.removeExcessItems();
    }

    private void addItems(Collection<T> collection, double d) {
        for (Serializable serializable : collection) {
            this.add(serializable, d);
        }
    }

    public synchronized void add(Map<T, Double> map) {
        this.addItems(map);
        this.removeExcessItems();
    }

    private void addItems(Map<T, Double> map) {
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            this.add((Serializable)entry.getKey(), (double)entry.getValue());
        }
    }

    private void add(T t, double d) {
        Double d2 = this.item2weight.get(t);
        if (d2 == null) {
            d2 = 0.0;
        }
        this.item2weight.put(t, d2 + d);
    }

    private void removeExcessItems() {
        if (this.item2weight.size() <= this.size) {
            return;
        }
        List<T> list = this.orderByWeight(this.item2weight);
        this.removeItems(list.subList(this.size, list.size()));
    }

    private List<T> orderByWeight(final Map<T, Double> map) {
        ArrayList<T> arrayList = new ArrayList<T>(map.keySet());
        Collections.sort(arrayList, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return -Double.compare((Double)map.get(t), (Double)map.get(t2));
            }
        });
        return arrayList;
    }

    private void removeItems(List<T> list) {
        for (Serializable serializable : list) {
            this.item2weight.remove(serializable);
        }
    }
}

