/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SnakeKeyMap<KH, KT, V>
implements Serializable {
    private static final long serialVersionUID = -3395592019378118666L;
    private HashMap<KH, HashMap<KT, V>> storage = new HashMap();

    public boolean containsKey(KH KH, KT KT) {
        return this.storage.containsKey(KH) && this.storage.get(KH).containsKey(KT);
    }

    public V get(KH KH, KT KT) {
        if (this.containsKey(KH, KT)) {
            return this.storage.get(KH).get(KT);
        }
        return null;
    }

    public V put(KH KH, KT KT, V v) {
        if (this.storage.containsKey(KH)) {
            return this.storage.get(KH).put(KT, v);
        }
        HashMap<KT, V> hashMap = new HashMap<KT, V>();
        hashMap.put(KT, v);
        this.storage.put(KH, hashMap);
        return null;
    }

    public Map<KT, V> getTails(KH KH) {
        return this.storage.get(KH);
    }

    public Collection<V> getAllValues() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (Map.Entry<KH, HashMap<KT, V>> entry : this.storage.entrySet()) {
            arrayList.addAll(entry.getValue().values());
        }
        return arrayList;
    }

    public Collection<KH> getHeads() {
        return this.storage.keySet();
    }

    public void remove(KH KH) {
        this.storage.remove(KH);
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<KH, HashMap<KT, V>> entry : this.storage.entrySet()) {
            for (Map.Entry<KT, V> entry2 : entry.getValue().entrySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(entry.getKey()).append("=").append(entry2.getKey()).append("=").append(entry2.getValue());
                arrayList.add(stringBuilder.toString());
            }
        }
        StringBuilder stringBuilder = new StringBuilder("{").append(StringUtils.join(arrayList, (String)", "));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

