/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapUtils {
    public static <K, V extends Comparable<? super V>> List<K> getSortedByValueKeys(final Map<? extends K, V> map) {
        ArrayList<? extends K> arrayList = new ArrayList<K>(map.keySet());
        Collections.sort(arrayList, new Comparator<K>(){

            @Override
            public int compare(K k, K k2) {
                return ((Comparable)map.get(k)).compareTo(map.get(k2));
            }
        });
        return arrayList;
    }

    public static <K, V extends Comparable<? super V>> K getKeyWithMaxValue(Map<K, V> map) {
        K k = null;
        Comparable comparable = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (comparable != null && ((Comparable)entry.getValue()).compareTo(comparable) <= 0) continue;
            comparable = (Comparable)entry.getValue();
            k = entry.getKey();
        }
        return k;
    }

    public static <K, V extends Comparable<? super V>> List<K> getKeyListWithMaxValue(Map<K, V> map, int n) {
        assert (n >= 0);
        assert (map != null);
        List<K> list = MapUtils.getSortedByValueKeys(map);
        ArrayList<K> arrayList = new ArrayList<K>(Math.min(n, list.size()));
        for (int i = list.size() - 1; i >= 0 && n > 0; --i, --n) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> getProjection(Map<K, V> map, Collection<K> collection) {
        assert (map != null);
        assert (collection != null);
        HashMap<K, V> hashMap = new HashMap<K, V>();
        if (collection != null) {
            for (K k : collection) {
                if (!map.containsKey(k)) continue;
                hashMap.put(k, map.get(k));
            }
        }
        return hashMap;
    }

    public static <K, V> Collection<V> getValues(Map<K, V> map, Collection<K> collection) {
        ArrayList<V> arrayList = new ArrayList<V>();
        if (collection != null) {
            for (K k : collection) {
                if (!map.containsKey(k)) continue;
                arrayList.add(map.get(k));
            }
        }
        return arrayList;
    }
}

