/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class BoundedPriorityQueue<T> {
    TreeSet<T> queue;
    final int limit;

    public BoundedPriorityQueue(int n, Comparator<T> comparator) {
        this.limit = n;
        this.queue = new TreeSet<T>(Collections.reverseOrder(comparator));
    }

    public void add(T t) {
        this.queue.add(t);
        if (this.queue.size() > this.limit) {
            T t2 = this.queue.last();
            this.queue.remove(t2);
        }
    }

    public List<T> toList() {
        return new ArrayList<T>(this.queue);
    }

    public String toString() {
        return this.toList().toString();
    }

    public T getLast() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.last();
    }
}

