/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections15.iterators.EmptyIterator;

public class AllCombinationsIterator<E>
implements Iterator<List<E>> {
    private List<Collection<E>> collections;
    private List<Iterator<E>> iterators;
    private ArrayList<E> values;

    public AllCombinationsIterator(List<Collection<E>> list) {
        int n = list != null ? list.size() : 0;
        this.collections = list;
        this.iterators = new ArrayList<Iterator<E>>(n);
        this.values = new ArrayList(n);
        this.init();
    }

    protected void init() {
        if (this.collections == null) {
            return;
        }
        for (Collection<E> collection : this.collections) {
            this.iterators.add(this.getIterator(collection));
        }
        int n = 0;
        while (n < this.collections.size()) {
            this.values.add(null);
            if (!this.iterators.get(n++).hasNext()) continue;
        }
        while (n < this.collections.size()) {
            if (this.iterators.get(n).hasNext()) {
                this.values.add(this.iterators.get(n).next());
            } else {
                this.values.add(null);
            }
            ++n;
        }
    }

    protected Iterator<E> getIterator(Collection<E> collection) {
        if (collection == null) {
            Iterator iterator = EmptyIterator.INSTANCE;
            return iterator;
        }
        return collection.iterator();
    }

    @Override
    public boolean hasNext() {
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.generateNext();
        return new ArrayList<E>(this.values);
    }

    private void generateNext() {
        int n = 0;
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) {
                ++n;
                continue;
            }
            this.setValue(n, iterator);
            break;
        }
        if (n != 0) {
            Iterator<Object> iterator = this.collections.iterator();
            for (int i = 0; i < n; ++i) {
                Iterator<E> iterator2 = this.getIterator((Collection)iterator.next());
                this.iterators.set(i, iterator2);
                this.setValue(i, iterator2);
            }
        }
    }

    protected void setValue(int n, Iterator<E> iterator) {
        if (iterator.hasNext()) {
            this.values.set(n, iterator.next());
        } else {
            this.values.set(n, null);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

