/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.functional;

import java.util.Iterator;
import ru.ispras.modis.functional.FilterFunction;

public class Filter<T>
implements Iterable<T> {
    private final Iterable<T> subj;
    private final FilterFunction<T> f;

    public Filter(FilterFunction<T> filterFunction, Iterable<T> iterable) {
        this.subj = iterable;
        this.f = filterFunction;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator(this.subj.iterator());
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<T> it;
        private T item;
        private boolean hasNext;

        private FilterIterator(Iterator<T> iterator) {
            this.it = iterator;
            this.nextFilter();
        }

        private void nextFilter() {
            while (this.it.hasNext()) {
                this.item = this.it.next();
                if (!Filter.this.f.satisfy(this.item)) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            Object t = this.item;
            this.nextFilter();
            return t;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

