/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.api.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;

public final class ConfigurationUtils {
    public static <T> T newInstance(String type, Class<T> superType, Class<?>[] paramTypes, Object[] params) {
        return ConfigurationUtils.newInstance(ConfigurationUtils.getType(type, superType), paramTypes, params);
    }

    public static <T> T newInstance(Class<? extends T> type, Class<?>[] paramTypes, Object[] params) {
        try {
            return type.getConstructor(paramTypes).newInstance(params);
        }
        catch (NoSuchMethodException e) {
            throw new TexterraConfigException(String.format("%s has no constructor with %s param types.", type, Arrays.asList(paramTypes)), (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TexterraConfigException(String.format("%s can not be instantiated.", type), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TexterraConfigException(String.format("Instantiation of %s failed.", type), (Throwable)e);
        }
    }

    public static <T> Class<? extends T> getType(String type, Class<T> superType) {
        try {
            return Class.forName(type).asSubclass(superType);
        }
        catch (ClassNotFoundException e) {
            throw new TexterraConfigException(String.format("Could not find class %s.", type), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new TexterraConfigException(String.format("Class %s is not a subtype of %s.", type, superType.getName()), (Throwable)e);
        }
    }
}

