/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.lemmatizer.word;

import java.util.Arrays;
import java.util.List;
import ru.ispras.texterra.utils.lemmatizer.word.IWordLemmatizer;

public class CompositeWordLemmatizer
implements IWordLemmatizer {
    private static final long serialVersionUID = -9137991217766830222L;
    private final List<? extends IWordLemmatizer> lemmatizers;

    public CompositeWordLemmatizer(List<? extends IWordLemmatizer> lemmatizers) {
        this.lemmatizers = lemmatizers;
    }

    public CompositeWordLemmatizer(IWordLemmatizer ... lemmatizers) {
        this(Arrays.asList(lemmatizers));
    }

    @Override
    public String getLemma(String word) {
        String lemma = word;
        for (IWordLemmatizer iWordLemmatizer : this.lemmatizers) {
            lemma = iWordLemmatizer.getLemma(lemma);
        }
        return lemma;
    }
}

