/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.datamodel;

import java.util.HashMap;
import java.util.Map;

public class Link
implements Comparable<Link> {
    private final int fromId;
    private final Type type;
    private final int toId;

    public Link(int fromId, Type type, int toId) {
        this.fromId = fromId;
        this.type = type;
        this.toId = toId;
    }

    public Link(Link other) {
        this(other.fromId, other.type, other.toId);
    }

    public int getFromId() {
        return this.fromId;
    }

    public Type getType() {
        return this.type;
    }

    public int getToId() {
        return this.toId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        return this.fromId == other.fromId && this.type == other.type && this.toId == other.toId;
    }

    @Override
    public int compareTo(Link otherLink) {
        if (this.fromId != otherLink.fromId) {
            return this.fromId - otherLink.fromId;
        }
        if (this.toId != otherLink.toId) {
            return this.toId - otherLink.toId;
        }
        return this.type.getName().compareTo(otherLink.type.getName());
    }

    public static enum Type {
        REGULAR("RL"),
        SEE_ALSO("SA"),
        RELATED("MP"),
        CATEGORY("CT"),
        BACK_REGULAR("BR"),
        BACK_SEE_ALSO("BS"),
        BACK_RELATED("BM"),
        BACK_CATEGORY("BC"),
        INFO_BOX("IB"),
        BACK_INFO_BOX("BI"),
        DOUBLE("DB");

        private static final Map<String, Type> namesToTypes;
        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type getType(String name) {
            return namesToTypes.get(name);
        }

        private static Map<String, Type> constructNamesToTypes() {
            HashMap<String, Type> namesToTypes = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                namesToTypes.put(type.getName(), type);
            }
            return namesToTypes;
        }

        static {
            namesToTypes = Type.constructNamesToTypes();
        }
    }
}

