/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.PredicateUtils;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;

public final class NLPDocumentFilteringUtils {
    @SafeVarargs
    public static INLPDocument keepAnnotations(INLPDocument doc, Class<? extends IAnnotation> ... neededAnnotations) {
        return NLPDocumentFilteringUtils.keepAnnotations(doc, Arrays.asList(neededAnnotations));
    }

    public static INLPDocument keepAnnotations(INLPDocument doc, Collection<Class<? extends IAnnotation>> neededAnnotations) {
        Collection<Class<? extends IAnnotation>> types = NLPDocumentFilteringUtils.filterSubclasses(neededAnnotations);
        return NLPDocumentFilteringUtils.keep(doc, types);
    }

    @SafeVarargs
    public static INLPDocument removeAnnotations(INLPDocument doc, Class<? extends IAnnotation> ... unneededAnnotations) {
        return NLPDocumentFilteringUtils.removeAnnotations(doc, Arrays.asList(unneededAnnotations));
    }

    public static INLPDocument removeAnnotations(INLPDocument doc, Collection<Class<? extends IAnnotation>> unneededAnnotations) {
        Collection<Class<? extends IAnnotation>> types = NLPDocumentFilteringUtils.minus(NLPDocumentFilteringUtils.filterSubclasses(doc.getAnnotationsTypes()), NLPDocumentFilteringUtils.filterSubclasses(unneededAnnotations));
        return NLPDocumentFilteringUtils.keep(doc, types);
    }

    @SafeVarargs
    public static INLPDocument filterAnnotations(INLPDocument doc, FilteringOptions filtering, Class<? extends IAnnotation> ... classes) {
        return NLPDocumentFilteringUtils.filterAnnotations(doc, filtering, Arrays.asList(classes));
    }

    public static INLPDocument filterAnnotations(INLPDocument doc, FilteringOptions filtering, Collection<Class<? extends IAnnotation>> classes) {
        switch (filtering) {
            case KEEPING: {
                return NLPDocumentFilteringUtils.keepAnnotations(doc, classes);
            }
            case REMOVING: {
                return NLPDocumentFilteringUtils.removeAnnotations(doc, classes);
            }
        }
        return doc;
    }

    private static Collection<Class<? extends IAnnotation>> minus(Collection<Class<? extends IAnnotation>> existingTypes, Collection<Class<? extends IAnnotation>> unneededTypes) {
        ArrayList<Class<? extends IAnnotation>> result = new ArrayList<Class<? extends IAnnotation>>();
        for (Class<? extends IAnnotation> existingType : existingTypes) {
            if (NLPDocumentFilteringUtils.containsAssignableFrom(unneededTypes, existingType)) continue;
            result.add(existingType);
        }
        return result;
    }

    private static INLPDocument keep(INLPDocument doc, Collection<Class<? extends IAnnotation>> types) {
        INLPDocument result = new DefaultDocumentFactory().create(doc.getText());
        for (Class<? extends IAnnotation> type : types) {
            result = result.withAnnotations(doc.getAnnotations(type));
        }
        return result;
    }

    private static Collection<Class<? extends IAnnotation>> filterSubclasses(Collection<Class<? extends IAnnotation>> types) {
        ArrayList<Class<? extends IAnnotation>> result = new ArrayList<Class<? extends IAnnotation>>();
        for (Class<? extends IAnnotation> type : types) {
            if (NLPDocumentFilteringUtils.containsAssignableFrom(result, type)) continue;
            CollectionUtils.filter(result, (Predicate)PredicateUtils.notPredicate((Predicate)new IsAssignableToPreducate(type)));
            result.add(type);
        }
        return result;
    }

    private static boolean containsAssignableFrom(Collection<Class<? extends IAnnotation>> types, Class<? extends IAnnotation> type) {
        return CollectionUtils.find(types, (Predicate)new IsAssignableFromPreducate(type)) != null;
    }

    private static class IsAssignableFromPreducate
    implements Predicate<Class<? extends IAnnotation>> {
        private final Class<? extends IAnnotation> type;

        IsAssignableFromPreducate(Class<? extends IAnnotation> type) {
            this.type = type;
        }

        public boolean evaluate(Class<? extends IAnnotation> element) {
            return element.isAssignableFrom(this.type);
        }
    }

    private static class IsAssignableToPreducate
    implements Predicate<Class<? extends IAnnotation>> {
        private final Class<? extends IAnnotation> type;

        IsAssignableToPreducate(Class<? extends IAnnotation> type) {
            this.type = type;
        }

        public boolean evaluate(Class<? extends IAnnotation> element) {
            return this.type.isAssignableFrom(element);
        }
    }

    public static enum FilteringOptions {
        KEEPING,
        REMOVING,
        NO_FILTERING;

    }
}

