/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.serializers.simple;

import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.convert.Converter;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.ekb.interfaces.IKBWalker;
import ru.ispras.texterra.core.nlp.serializers.ISerializerFactory;
import ru.ispras.texterra.core.nlp.serializers.simple.ConceptConverter;
import ru.ispras.texterra.core.nlp.serializers.simple.SimpleSerializer;
import ru.ispras.texterra.core.nlp.serializers.simple.StringConverter;

public class SimpleSerializerFactory
implements ISerializerFactory {
    private final Map<Class<?>, Converter<?>> converters = new HashMap();

    public SimpleSerializerFactory() {
        this.converters.putAll(this.getDefaultConverters());
    }

    public SimpleSerializerFactory(Map<Class<?>, Converter<?>> converters) {
        this();
        this.converters.putAll(converters);
    }

    public SimpleSerializerFactory(IKBWalker kbwalker) {
        this();
        this.converters.putAll(this.getDefaultKBConverters(kbwalker));
    }

    public SimpleSerializerFactory(IKBWalker kbwalker, Map<Class<?>, Converter<?>> converters) {
        this(kbwalker);
        this.converters.putAll(converters);
    }

    @Override
    public SimpleSerializer create() {
        return new SimpleSerializer(this.converters);
    }

    private Map<Class<?>, Converter<?>> getDefaultConverters() {
        HashMap converters = new HashMap();
        converters.put(String.class, new StringConverter());
        return converters;
    }

    private Map<Class<?>, Converter<?>> getDefaultKBConverters(IKBWalker kbwalker) {
        HashMap converters = new HashMap();
        converters.put(Concept.class, new ConceptConverter(kbwalker));
        return converters;
    }
}

