/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.serializers.simple;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import ru.ispras.modis.geo.Coordinate;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.common.concept.AttributedConcept;
import ru.ispras.texterra.core.common.concept.AttributesFactory;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.common.concept.CoordinatesAttribute;
import ru.ispras.texterra.core.common.concept.DefinitionAttribute;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.common.concept.MobileURLAttribute;
import ru.ispras.texterra.core.common.concept.SynonymAttribute;
import ru.ispras.texterra.core.common.concept.TitleAttribute;
import ru.ispras.texterra.core.common.concept.TranslationAttribute;
import ru.ispras.texterra.core.common.concept.TypeAttribute;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.ekb.interfaces.IKBWalker;

public class ConceptConverter
implements Converter<Concept> {
    @ConfigurationProperty
    private static final String appendCoordinatesAttributeProperty = "appendCoordinatesAttribute";
    @ConfigurationProperty
    private static final String appendDefinitionAttributeProperty = "appendDefinitionAttribute";
    @ConfigurationProperty
    private static final String appendUrlAttributeProperty = "appendUrlAttribute";
    @ConfigurationProperty
    private static final String appendSynonymAttributeProperty = "appendSynonymAttribute";
    @ConfigurationProperty
    private static final String appendTitleAttributeProperty = "appendTitleAttribute";
    @ConfigurationProperty
    private static final String appendTranslationAttributeProperty = "appendTranslationAttribute";
    @ConfigurationProperty
    private static final String appendTypeAttributeProperty = "appendTypeAttribute";
    private static final List<IAttribute> attributeList = ConceptConverter.prepareAttributeList();
    private final IKBWalker kbWalker;
    private static final Map<String, Class<? extends IAttribute>> attributesShortcuts = ConceptConverter.getAttributesShortcuts();

    public ConceptConverter(IKBWalker kbWalker) {
        this.kbWalker = kbWalker;
    }

    private static List<IAttribute> prepareAttributeList() {
        String translationAttributeLang;
        String urlAttributeLang;
        TexterraConfiguration configuration = TexterraConfigurationFactory.getConfiguration();
        AttributesFactory attributesFactory = new AttributesFactory();
        if (configuration.getBoolProperty(ConceptConverter.class, appendCoordinatesAttributeProperty)) {
            attributesFactory.addCoordinatesAttribute();
        }
        if (configuration.getBoolProperty(ConceptConverter.class, appendDefinitionAttributeProperty)) {
            attributesFactory.addDefinitionAttribute();
        }
        if (configuration.getBoolProperty(ConceptConverter.class, appendSynonymAttributeProperty)) {
            attributesFactory.addSynonymsAttribute();
        }
        if (configuration.getBoolProperty(ConceptConverter.class, appendTitleAttributeProperty)) {
            attributesFactory.addTitleAttribute();
        }
        if (configuration.getBoolProperty(ConceptConverter.class, appendTypeAttributeProperty)) {
            attributesFactory.addTypeAttribute();
        }
        if (!(urlAttributeLang = configuration.getStringProperty(ConceptConverter.class, appendUrlAttributeProperty)).isEmpty()) {
            attributesFactory.addMobileURLAttribute(urlAttributeLang);
        }
        if (!(translationAttributeLang = configuration.getStringProperty(ConceptConverter.class, appendTranslationAttributeProperty)).isEmpty()) {
            attributesFactory.addTranslationAttribute(translationAttributeLang);
        }
        return attributesFactory.toAttributeList();
    }

    private static Map<String, Class<? extends IAttribute>> getAttributesShortcuts() {
        LinkedHashMap<String, Class<? extends IAttribute>> result = new LinkedHashMap<String, Class<? extends IAttribute>>();
        result.put("coordinates", CoordinatesAttribute.class);
        result.put("definition", DefinitionAttribute.class);
        result.put("url", MobileURLAttribute.class);
        result.put("synonym", SynonymAttribute.class);
        result.put("title", TitleAttribute.class);
        result.put("translation", TranslationAttribute.class);
        result.put("type", TypeAttribute.class);
        return result;
    }

    public Concept read(InputNode node) throws Exception {
        int id = Integer.parseInt(node.getNext("id").getValue());
        String kbName = node.getNext("kbname").getValue();
        node.skip();
        return new Concept(kbName, id);
    }

    public void write(OutputNode node, Concept concept) throws Exception {
        node.getChild("id").setValue(String.valueOf(concept.getId()));
        node.getChild("kbname").setValue(concept.getKbName());
        AttributedConcept attributedConcept = this.kbWalker.getAttributedConcept(concept, attributeList);
        for (Map.Entry<String, Class<? extends IAttribute>> nodeName2attributeClass : attributesShortcuts.entrySet()) {
            IAttribute attribute = attributedConcept.getAttribute(nodeName2attributeClass.getValue());
            if (attribute == null) continue;
            OutputNode childNode = node.getChild(nodeName2attributeClass.getKey());
            this.writeAttribute(childNode, attribute);
        }
    }

    private void writeAttribute(OutputNode childNode, IAttribute attribute) throws Exception {
        if (attribute instanceof CoordinatesAttribute) {
            this.writeCoordinatesAttribute(childNode, (CoordinatesAttribute)attribute);
        } else if (attribute instanceof DefinitionAttribute) {
            this.writeDefinitionAttribute(childNode, (DefinitionAttribute)attribute);
        } else if (attribute instanceof MobileURLAttribute) {
            this.writeMobileURLAttribute(childNode, (MobileURLAttribute)attribute);
        } else if (attribute instanceof SynonymAttribute) {
            this.writeSynonymAttribute(childNode, (SynonymAttribute)attribute);
        } else if (attribute instanceof TitleAttribute) {
            this.writeTitleAttribute(childNode, (TitleAttribute)attribute);
        } else if (attribute instanceof TranslationAttribute) {
            this.writeTranslationAttribute(childNode, (TranslationAttribute)attribute);
        } else if (attribute instanceof TypeAttribute) {
            this.writeTypeAttribute(childNode, (TypeAttribute)attribute);
        }
    }

    private void writeTypeAttribute(OutputNode childNode, TypeAttribute attribute) {
        childNode.setValue(attribute.getType().toString());
    }

    private void writeTranslationAttribute(OutputNode childNode, TranslationAttribute attribute) throws Exception {
        childNode.setAttribute("lang", attribute.getTranslationLanguage());
        for (String translation : attribute.getTranslations()) {
            childNode.getChild("translation").setValue(translation);
        }
    }

    private void writeTitleAttribute(OutputNode childNode, TitleAttribute attribute) {
        childNode.setValue(attribute.getTitle());
    }

    private void writeSynonymAttribute(OutputNode childNode, SynonymAttribute attribute) throws Exception {
        for (SynonymAttribute.Pair pair : attribute.getSynonyms()) {
            OutputNode child = childNode.getChild("synonim");
            child.setAttribute("weight", String.valueOf(pair.getWeight()));
            child.setValue(pair.getSynonym());
        }
    }

    private void writeMobileURLAttribute(OutputNode childNode, MobileURLAttribute attribute) {
        childNode.setValue(attribute.getUrl());
    }

    private void writeDefinitionAttribute(OutputNode childNode, DefinitionAttribute attribute) {
        childNode.setValue(attribute.getDefinition());
    }

    private void writeCoordinatesAttribute(OutputNode childNode, CoordinatesAttribute attribute) throws Exception {
        for (Coordinate c : attribute.getCoordinates()) {
            OutputNode coordinateNode = childNode.getChild("coordinate");
            coordinateNode.setValue(c.toString());
        }
    }
}

