/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.factories;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;

public interface IDocumentFactory {
    public INLPDocument create(String var1);

    default public INLPDocument create(InputStream inputStream) {
        return this.create(inputStream, "UTF-8");
    }

    default public INLPDocument create(InputStream inputStream, String encoding) {
        try {
            return this.create(IOUtils.toString((InputStream)inputStream, (String)encoding));
        }
        catch (IOException e) {
            throw new TexterraSystemException(e);
        }
    }

    default public INLPDocument create(Reader reader) {
        try {
            return this.create(IOUtils.toString((Reader)reader));
        }
        catch (IOException e) {
            throw new TexterraSystemException(e);
        }
    }
}

