/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datasets.sentiment;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.SentimentPolarity;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;

class LineByLineSentimentDatasetIterator
implements Iterator<INLPDocument> {
    private static final Pattern linePattern = Pattern.compile("^(-?\\d)\\s(\"?)(.*?)\\2$");
    private final File dataSet;
    private final Scanner scanner;
    private boolean closed = false;

    public LineByLineSentimentDatasetIterator(File dataSet) {
        this.dataSet = dataSet;
        try {
            this.scanner = new Scanner(dataSet, "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new TexterraSystemException(e);
        }
    }

    @Override
    public boolean hasNext() {
        this.closeIfExhausted();
        if (this.closed) {
            return false;
        }
        return this.scanner.hasNextLine();
    }

    @Override
    public INLPDocument next() {
        this.closeIfExhausted();
        if (this.closed) {
            throw new NoSuchElementException();
        }
        String line = this.scanner.nextLine();
        Matcher matcher = linePattern.matcher(line = line.replaceAll("\"{2,}", "\""));
        if (!matcher.matches()) {
            this.scanner.close();
            throw new TexterraSystemException(String.format("File %s is not in appropriate format.", this.dataSet));
        }
        return this.extractDocument(Integer.parseInt(matcher.group(1)), matcher.group(3));
    }

    private INLPDocument extractDocument(int sentiment, String text) {
        INLPDocument document = new NLPDocument(text);
        if (sentiment != 0) {
            SentimentPolarity.Direction polarityDirection = sentiment > 0 ? SentimentPolarity.Direction.POSITIVE : SentimentPolarity.Direction.NEGATIVE;
            document = document.withAnnotations(Arrays.asList(new SentimentSubjectivity(document), new SentimentPolarity(document, polarityDirection)));
        }
        return document;
    }

    private void closeIfExhausted() {
        if (!this.closed && !this.scanner.hasNextLine()) {
            this.scanner.close();
            this.closed = true;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

