/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datasets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.filefilter.TrueFileFilter;
import ru.ispras.modis.utils.concurrent.StreamProcessor;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocument;
import ru.ispras.texterra.core.nlp.datasets.IDatasetReader;
import ru.ispras.texterra.core.nlp.serializers.ConfigurableSerializerFactory;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;

public class DeserializationDatasetReader
implements IDatasetReader {
    private final File inputDir;
    private final ISerializer serializer;
    private final FilenameFilter filter;

    @Deprecated
    public DeserializationDatasetReader(File inputDir) {
        this(inputDir, (FilenameFilter)TrueFileFilter.TRUE);
    }

    public DeserializationDatasetReader(File inputDir, ISerializer serializer) {
        this(inputDir, (FilenameFilter)TrueFileFilter.TRUE, serializer);
    }

    @Deprecated
    public DeserializationDatasetReader(File inputDir, FilenameFilter filter) {
        this(inputDir, filter, ConfigurableSerializerFactory.getInstance().create());
    }

    public DeserializationDatasetReader(File inputDir, FilenameFilter filter, ISerializer serializer) {
        this.inputDir = inputDir;
        this.filter = filter;
        this.serializer = serializer;
    }

    @Override
    public Iterable<INLPDocument> read() {
        return new StreamProcessor().transform(Arrays.asList(this.inputDir.listFiles(this.filter)), (StreamProcessor.IElementTransformer)new StreamProcessor.IElementTransformer<File, INLPDocument>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public INLPDocument transformElement(File file) {
                try (FileInputStream in = new FileInputStream(file);){
                    INLPDocument iNLPDocument = DeserializationDatasetReader.this.serializer.read(NLPDocument.class, in);
                    return iNLPDocument;
                }
                catch (IOException e) {
                    throw new TexterraSystemException(e);
                }
            }
        });
    }
}

