/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.storage;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class StoredClassesHierarchy<R>
implements Serializable {
    private static final long serialVersionUID = 2092325493820048436L;
    private static final Map<Class<?>, Set<Class<?>>> classInterfaceHierarchy = new ConcurrentHashMap();
    private final Map<Class<? extends R>, Set<Class<? extends R>>> concreteSubClasses;
    private final Class<R> rootClass;

    private StoredClassesHierarchy(Map<Class<? extends R>, Set<Class<? extends R>>> concreteSubClasses, Class<R> rootClass) {
        this.concreteSubClasses = this.copyConcreteSubclasses(concreteSubClasses);
        this.rootClass = rootClass;
    }

    private Map<Class<? extends R>, Set<Class<? extends R>>> copyConcreteSubclasses(Map<Class<? extends R>, Set<Class<? extends R>>> other) {
        HashMap<Class<R>, Set<Class<R>>> result = new HashMap<Class<R>, Set<Class<R>>>();
        for (Map.Entry<Class<R>, Set<Class<R>>> entry : other.entrySet()) {
            result.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return result;
    }

    public StoredClassesHierarchy(StoredClassesHierarchy<R> other) {
        this(other.concreteSubClasses, other.rootClass);
    }

    public StoredClassesHierarchy(Class<R> rootClass) {
        this(new HashMap<Class<? extends R>, Set<Class<? extends R>>>(), rootClass);
    }

    public <T extends R> Set<Class<? extends T>> getClassesAssignableFrom(Class<T> klass) {
        Set<Class<? extends T>> classes = this.concreteSubClasses.get(klass);
        if (classes != null) {
            return classes;
        }
        if (!klass.isInterface()) {
            return Collections.singleton(klass);
        }
        return Collections.emptySet();
    }

    public void store(Collection<Class<? extends R>> klasses) {
        for (Class<R> clazz : klasses) {
            this.store(clazz);
        }
    }

    public void store(Class<? extends R> klass) {
        List<Class<R>> classHierarchy = this.getUnknownClassHierarchy(klass);
        for (Class<? extends R> clazz : classHierarchy) {
            this.storeMappings(clazz);
        }
    }

    private List<Class<? extends R>> getUnknownClassHierarchy(Class<? extends R> klass) {
        LinkedList<Class<R>> result = new LinkedList<Class<R>>();
        for (Class<R> current = klass; current != null && this.rootClass.isAssignableFrom(current) && !this.concreteSubClasses.containsKey(klass); current = current.getSuperclass()) {
            result.add(0, current);
        }
        return result;
    }

    private void storeMappings(Class<? extends R> klass) {
        for (Class<R> superClass : StoredClassesHierarchy.getClassInterfaceHierarchy(klass)) {
            if (!this.rootClass.isAssignableFrom(superClass)) continue;
            Class<R> castedSuperClass = superClass;
            Set<Class<R>> subClasses = this.concreteSubClasses.get(castedSuperClass);
            if (subClasses == null) {
                subClasses = new HashSet<Class<? extends R>>();
                this.concreteSubClasses.put(castedSuperClass, subClasses);
            }
            subClasses.add(klass);
        }
    }

    private static Set<Class<?>> getClassInterfaceHierarchy(Class<?> klass) {
        Set<Class<?>> result = classInterfaceHierarchy.get(klass);
        if (result != null) {
            return result;
        }
        result = new HashSet();
        result.add(klass);
        for (Class<?> superClass : klass.getInterfaces()) {
            result.addAll(StoredClassesHierarchy.getClassInterfaceHierarchy(superClass));
        }
        Class<?> superClass = klass.getSuperclass();
        if (superClass != null) {
            result.addAll(StoredClassesHierarchy.getClassInterfaceHierarchy(superClass));
        }
        classInterfaceHierarchy.put(klass, result);
        return result;
    }
}

