/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ByStartAnnotationsComparator;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainedAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public class ContainedAnnotationRelationCacheBuilder
implements IAnnotationRelationCacheBuilder {
    private static final ContainedAnnotationRelation relation = new ContainedAnnotationRelation();
    private static final Comparator<IAnnotation> byStartAnnotationsComparator = new ByStartAnnotationsComparator();

    @Override
    public Map<IAnnotation, Collection<? extends IAnnotation>> buildCache(List<? extends IAnnotation> baseAnnotations, List<? extends IAnnotation> targetAnnotations) {
        HashMap<IAnnotation, Collection<? extends IAnnotation>> result = new HashMap<IAnnotation, Collection<? extends IAnnotation>>();
        for (IAnnotation iAnnotation : baseAnnotations) {
            result.put(iAnnotation, this.getInRelationAnnotations(iAnnotation, targetAnnotations));
        }
        return result;
    }

    private List<IAnnotation> getInRelationAnnotations(IAnnotation baseAnnotation, List<? extends IAnnotation> annotations) {
        ArrayList<IAnnotation> result = new ArrayList<IAnnotation>();
        int position = this.getMaxPosition(annotations, baseAnnotation);
        if (position < 0) {
            position = -position - 2;
        }
        for (int i = 0; i <= position; ++i) {
            IAnnotation another = annotations.get(i);
            if (!relation.areInRelation(baseAnnotation, another)) continue;
            result.add(another);
        }
        return result;
    }

    private int getMaxPosition(List<? extends IAnnotation> annotations, IAnnotation annotation) {
        int position = Collections.binarySearch(annotations, annotation, byStartAnnotationsComparator);
        if (position < 0) {
            return position;
        }
        while (position < annotations.size() - 1 && byStartAnnotationsComparator.compare(annotations.get(position + 1), annotation) == 0) {
            ++position;
        }
        return position;
    }

    @Override
    public IAnnotationRelation getRelation() {
        return relation;
    }
}

