/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.relations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.ispras.modis.utils.collections.AbstractChunkedIterator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.utils.AnnotationUtils;

public final class CoinsidesAnnotationRelationCacheBuilder
implements IAnnotationRelationCacheBuilder {
    private static final IAnnotationRelation relation = new CoinsidesAnnotationRelation();

    @Override
    public Map<IAnnotation, Collection<? extends IAnnotation>> buildCache(List<? extends IAnnotation> baseTypeAnnotations, List<? extends IAnnotation> targetTypeAnnotations) {
        CoincidingAnnotationsIterator baseIt = new CoincidingAnnotationsIterator(baseTypeAnnotations.iterator());
        CoincidingAnnotationsIterator targetIt = new CoincidingAnnotationsIterator(targetTypeAnnotations.iterator());
        HashMap<IAnnotation, Collection<? extends IAnnotation>> cache = new HashMap<IAnnotation, Collection<? extends IAnnotation>>();
        List baseAnnotations = (List)this.safeNext((Iterator)((Object)baseIt));
        List targetAnnotations = (List)this.safeNext((Iterator)((Object)targetIt));
        while (baseAnnotations != null && targetAnnotations != null) {
            if (((IAnnotation)baseAnnotations.get(0)).getStart() < ((IAnnotation)targetAnnotations.get(0)).getStart()) {
                baseAnnotations = (List)this.safeNext((Iterator)((Object)baseIt));
                continue;
            }
            if (((IAnnotation)baseAnnotations.get(0)).getStart() > ((IAnnotation)targetAnnotations.get(0)).getStart()) {
                targetAnnotations = (List)this.safeNext((Iterator)((Object)targetIt));
                continue;
            }
            if (((IAnnotation)baseAnnotations.get(0)).getEnd() == ((IAnnotation)targetAnnotations.get(0)).getEnd()) {
                this.addToCache(cache, baseAnnotations, targetAnnotations);
            }
            baseAnnotations = (List)this.safeNext((Iterator)((Object)baseIt));
            targetAnnotations = (List)this.safeNext((Iterator)((Object)targetIt));
        }
        return cache;
    }

    private void addToCache(Map<IAnnotation, Collection<? extends IAnnotation>> cache, List<? extends IAnnotation> baseAnnotations, List<? extends IAnnotation> targetAnnotations) {
        for (IAnnotation iAnnotation : baseAnnotations) {
            cache.put(iAnnotation, targetAnnotations);
        }
    }

    private <T> T safeNext(Iterator<T> it) {
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public IAnnotationRelation getRelation() {
        return relation;
    }

    private static final class CoincidingAnnotationsIterator
    extends AbstractChunkedIterator<IAnnotation> {
        public CoincidingAnnotationsIterator(Iterator<? extends IAnnotation> iterator) {
            super(iterator);
        }

        protected boolean areInTheSameChunk(IAnnotation first, IAnnotation second) {
            return AnnotationUtils.coincides(first, second);
        }
    }
}

