/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.pos.penn;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;

public enum PennPOSTag implements IPOSTag
{
    CC,
    COLON,
    COMMA,
    DOT,
    DT,
    IN,
    JJ,
    JJR,
    JJS,
    NN,
    NNP,
    NNPS,
    NNS,
    PARENTHESIS_LEFT,
    PARENTHESIS_RIGHT,
    QUOTE,
    RB,
    RBR,
    RBS,
    VB,
    VBD,
    VBG,
    VBN,
    VBP,
    VBZ,
    WDT,
    OTHER;

    private static final Set<PennPOSTag> adjectives;
    private static final Set<PennPOSTag> adverbs;
    private static final Set<PennPOSTag> punctuation;
    private static final Set<PennPOSTag> nouns;
    private static final Set<PennPOSTag> verbs;

    @Override
    public boolean isAdjective() {
        return adjectives.contains(this);
    }

    @Override
    public boolean isAdverb() {
        return adverbs.contains(this);
    }

    @Override
    public boolean isNoun() {
        return nouns.contains(this);
    }

    @Override
    public boolean isPunctuation() {
        return punctuation.contains(this);
    }

    @Override
    public boolean isVerb() {
        return verbs.contains(this);
    }

    @Override
    public boolean isDeterminer() {
        return this == DT;
    }

    @Override
    public boolean isNumeral() {
        return false;
    }

    @Override
    public String getTag() {
        return this.toString();
    }

    static {
        adjectives = new HashSet<PennPOSTag>(Arrays.asList(JJ, JJR, JJS));
        adverbs = new HashSet<PennPOSTag>(Arrays.asList(RB, RBR, RBS));
        punctuation = new HashSet<PennPOSTag>(Arrays.asList(COLON, COMMA, DOT, PARENTHESIS_LEFT, PARENTHESIS_RIGHT, QUOTE));
        nouns = new HashSet<PennPOSTag>(Arrays.asList(NN, NNP, NNPS, NNS));
        verbs = new HashSet<PennPOSTag>(Arrays.asList(VB, VBD, VBG, VBN, VBP, VBZ));
    }
}

