/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.pos.morph;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;

public final class MorphProperties
implements IMorphProperties {
    private static final long serialVersionUID = -1767630645964437032L;
    @Element(name="pos-tag")
    private final IPOSTag posTag;
    private final Map<Class<? extends IMorphCharacter>, IMorphCharacter> morphCharacters;

    public MorphProperties(@Element(name="pos-tag") IPOSTag posTag, @ElementList(name="characters") Collection<IMorphCharacter> morphCharacters) {
        this.posTag = Objects.requireNonNull(posTag);
        this.morphCharacters = ImmutableMap.copyOf(morphCharacters.stream().collect(Collectors.toMap(mc -> mc.getClass(), Function.identity())));
    }

    public MorphProperties(IPOSTag posTag, IMorphCharacter ... morphCharacters) {
        this(posTag, Arrays.asList(morphCharacters));
    }

    @Override
    public boolean isAdverb() {
        return this.posTag.isAdverb();
    }

    @Override
    public boolean isAdjective() {
        return this.posTag.isAdjective();
    }

    @Override
    public boolean isNoun() {
        return this.posTag.isNoun();
    }

    @Override
    public boolean isVerb() {
        return this.posTag.isVerb();
    }

    @Override
    public boolean isPunctuation() {
        return this.posTag.isPunctuation();
    }

    @Override
    public boolean isDeterminer() {
        return this.posTag.isDeterminer();
    }

    @Override
    public boolean isNumeral() {
        return this.posTag.isNumeral();
    }

    private List<IMorphCharacter> getSortedMorphCharacters() {
        ArrayList<Class<? extends IMorphCharacter>> morphCharacterClasses = new ArrayList<Class<? extends IMorphCharacter>>(this.morphCharacters.keySet());
        Collections.sort(morphCharacterClasses, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        ArrayList<IMorphCharacter> result = new ArrayList<IMorphCharacter>(morphCharacterClasses.size());
        for (Class clazz : morphCharacterClasses) {
            result.add(this.morphCharacters.get(clazz));
        }
        return result;
    }

    @Override
    public String getTag() {
        StringBuilder builder = new StringBuilder();
        builder = builder.append(this.posTag.getTag()).append('_');
        for (IMorphCharacter morphCharacter : this.getSortedMorphCharacters()) {
            builder = builder.append(morphCharacter.getValue()).append('_');
        }
        return builder.substring(0, builder.length() - 1);
    }

    @Override
    public IPOSTag getPOSTag() {
        return this.posTag;
    }

    @Override
    public <MC extends IMorphCharacter> Optional<MC> getMorphCharacter(Class<MC> type) {
        return Optional.ofNullable(this.morphCharacters.get(type));
    }

    @Override
    public Collection<IMorphCharacter> getMorphCharacters() {
        return this.morphCharacters.values();
    }

    @ElementList(name="characters")
    private Collection<IMorphCharacter> getMorphCharactersForSimple() {
        return new ArrayList<IMorphCharacter>(this.getMorphCharacters());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.morphCharacters.hashCode();
        result = 31 * result + this.posTag.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MorphProperties)) {
            return false;
        }
        MorphProperties other = (MorphProperties)obj;
        if (!this.morphCharacters.equals(other.morphCharacters)) {
            return false;
        }
        return this.posTag.equals(other.posTag);
    }

    public String toString() {
        return "[posTag=" + this.posTag + ", morphCharacters=" + this.getMorphCharacters() + "]";
    }
}

