/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.ElementMap;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.datamodel.IWeightedSemanticContextValue;

public class WeightedSemanticContextValue
implements IWeightedSemanticContextValue {
    private static final long serialVersionUID = -7269873583033836088L;
    @ElementMap(name="conceptsWeights")
    private Map<Concept, Double> conceptsWeights;

    public WeightedSemanticContextValue(@ElementMap(name="conceptsWeights") Map<Concept, Double> conceptsWeights) {
        this.conceptsWeights = conceptsWeights;
    }

    public WeightedSemanticContextValue(Collection<Concept> conceptlist) {
        this(WeightedSemanticContextValue.convertToMap(conceptlist));
    }

    @Override
    public Map<Concept, Double> getWeights() {
        return Collections.unmodifiableMap(this.conceptsWeights);
    }

    @Override
    public Set<Concept> getContext() {
        return Collections.unmodifiableSet(this.conceptsWeights.keySet());
    }

    private static Map<Concept, Double> convertToMap(Collection<Concept> conceptlist) {
        HashMap<Concept, Double> result = new HashMap<Concept, Double>();
        for (Concept concept : conceptlist) {
            Double value = (Double)result.get(concept);
            if (value == null) {
                value = 0.0;
            }
            result.put(concept, value + 1.0);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conceptsWeights == null ? 0 : this.conceptsWeights.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeightedSemanticContextValue other = (WeightedSemanticContextValue)obj;
        return !(this.conceptsWeights == null ? other.conceptsWeights != null : !this.conceptsWeights.equals(other.conceptsWeights));
    }
}

