/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.storage.HierarchicInstancesSortedStorage;
import ru.ispras.texterra.core.nlp.serializers.simple.SimpleSerializer;

@Root
@Order(elements={"text", "annotations"})
public final class NLPDocument
implements INLPDocument,
Serializable {
    private static final long serialVersionUID = 6617524625033330761L;
    public static final INLPDocument.AnnotationsComparator annotationsComparator = new INLPDocument.AnnotationsComparator();
    private final String text;
    private final HierarchicInstancesSortedStorage<IAnnotation> storage;

    NLPDocument(String text, HierarchicInstancesSortedStorage<IAnnotation> storage) {
        this.text = text;
        this.storage = storage;
    }

    NLPDocument(NLPDocument other) {
        this(other.text, other.storage);
    }

    public NLPDocument(String text) {
        this(text, new HierarchicInstancesSortedStorage<IAnnotation>(IAnnotation.class, annotationsComparator));
    }

    NLPDocument(@Element(name="text") String text, @ElementList(name="annotations") List<IAnnotation> annotations) {
        HierarchicInstancesSortedStorage<IAnnotation> newStorage = new HierarchicInstancesSortedStorage<IAnnotation>(IAnnotation.class, annotationsComparator);
        newStorage.addInstances(annotations);
        this.text = text;
        this.storage = newStorage;
    }

    @Override
    public INLPDocument withoutAnnotations() {
        return new NLPDocument(this.text);
    }

    @Override
    public <T extends IAnnotation> List<T> getAnnotations(Class<T> annotationClass) {
        return this.storage.getInstances(annotationClass);
    }

    @Override
    public <T extends IAnnotation> List<T> getInRelationAnnotations(IAnnotation baseAnnotation, IAnnotationRelation relation, Class<T> annotationClass) {
        ArrayList<IAnnotation> result = new ArrayList<IAnnotation>();
        for (IAnnotation annotation : this.getAnnotations(annotationClass)) {
            if (!relation.areInRelation(baseAnnotation, annotation)) continue;
            result.add(annotation);
        }
        return result;
    }

    @Override
    public NLPDocument withAnnotations(Collection<? extends IAnnotation> newAnnotations) {
        HierarchicInstancesSortedStorage<IAnnotation> newStorage = new HierarchicInstancesSortedStorage<IAnnotation>(this.storage);
        newStorage.addInstances(newAnnotations);
        return new NLPDocument(this.text, newStorage);
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Element(name="text")
    private final String getNormalizedText() {
        return SimpleSerializer.getNormalizedString(this.text);
    }

    @ElementList
    private final List<IAnnotation> getAnnotations() {
        return this.getAnnotations(IAnnotation.class);
    }

    @Override
    public <T extends IAnnotation> boolean hasAnnotations(Class<T> annotationClass) {
        return this.storage.hasInstances(annotationClass);
    }

    @Override
    public Set<Class<? extends IAnnotation>> getAnnotationsTypes() {
        return this.storage.getInstancesClasses();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NLPDocument)) {
            return false;
        }
        NLPDocument other = (NLPDocument)obj;
        if (this.storage == null ? other.storage != null : !this.storage.equals(other.storage)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public int hashCode() {
        return this.text == null ? 0 : this.text.hashCode();
    }
}

