/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.relations.AnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public final class FastInRelationNLPDocument
implements INLPDocument {
    public static final Comparator<IAnnotation> annotationsComparator = new INLPDocument.AnnotationsComparator();
    private final INLPDocument wrapped;
    private final Class<? extends IAnnotation> baseType;
    private final Class<? extends IAnnotation> targetType;
    private final IAnnotationRelationCacheBuilder cacheBuilder;
    private final IAnnotationRelation relation;
    private final Map<IAnnotation, INLPDocument> cache;

    public FastInRelationNLPDocument(INLPDocument wrapped, Class<? extends IAnnotation> baseType, Class<? extends IAnnotation> targetType, IAnnotationRelation relation) {
        this(wrapped, baseType, targetType, new AnnotationRelationCacheBuilder(relation));
    }

    public FastInRelationNLPDocument(INLPDocument wrapped, Class<? extends IAnnotation> baseType, Class<? extends IAnnotation> targetType, IAnnotationRelationCacheBuilder cacheBuilder) {
        this(wrapped, baseType, targetType, cacheBuilder, FastInRelationNLPDocument.mergeCaches(wrapped.getText(), new HashMap<IAnnotation, INLPDocument>(), cacheBuilder.buildCache(wrapped.getAnnotations(baseType), wrapped.getAnnotations(targetType))));
    }

    private FastInRelationNLPDocument(INLPDocument wrapped, Class<? extends IAnnotation> baseType, Class<? extends IAnnotation> targetType, IAnnotationRelationCacheBuilder cacheBuilder, Map<IAnnotation, INLPDocument> cache) {
        this.wrapped = wrapped;
        this.baseType = baseType;
        this.targetType = targetType;
        this.cacheBuilder = cacheBuilder;
        this.relation = cacheBuilder.getRelation();
        this.cache = cache;
    }

    @Override
    public INLPDocument withoutAnnotations() {
        return new FastInRelationNLPDocument(this.wrapped.withoutAnnotations(), this.baseType, this.targetType, this.cacheBuilder);
    }

    @Override
    public INLPDocument withAnnotations(Collection<? extends IAnnotation> newAnnotations) {
        List<IAnnotation> newBaseAnnotations = this.getAnnotationsByType(newAnnotations, this.baseType);
        List<IAnnotation> newTargetAnnotations = this.getAnnotationsByType(newAnnotations, this.targetType);
        Map<IAnnotation, INLPDocument> newCache = this.buildNewCache(newBaseAnnotations, newTargetAnnotations);
        return new FastInRelationNLPDocument(this.wrapped.withAnnotations(newAnnotations), this.baseType, this.targetType, this.cacheBuilder, newCache);
    }

    private <T extends IAnnotation> List<IAnnotation> getAnnotationsByType(Collection<? extends T> annotations, final Class<? extends IAnnotation> type) {
        ArrayList<? extends T> result = new ArrayList<T>(annotations);
        CollectionUtils.filter(result, (Predicate)new Predicate<IAnnotation>(){

            public boolean evaluate(IAnnotation annotation) {
                return type.isInstance(annotation);
            }
        });
        Collections.sort(result, annotationsComparator);
        return result;
    }

    private Map<IAnnotation, INLPDocument> buildNewCache(List<IAnnotation> newBaseAnnotations, List<IAnnotation> newTargetAnnotations) {
        if (newBaseAnnotations.isEmpty() && newTargetAnnotations.isEmpty()) {
            return this.cache;
        }
        HashMap<IAnnotation, INLPDocument> newCache = new HashMap<IAnnotation, INLPDocument>(this.cache);
        this.mergeCaches(newCache, this.buildNewBaseOldTargetCache(newBaseAnnotations));
        this.mergeCaches(newCache, this.buildOldBaseNewTargetCache(newTargetAnnotations));
        this.mergeCaches(newCache, this.buildNewBaseNewTargetCache(newBaseAnnotations, newTargetAnnotations));
        return newCache;
    }

    private Map<IAnnotation, Collection<? extends IAnnotation>> buildNewBaseOldTargetCache(List<IAnnotation> newBaseAnnotations) {
        if (newBaseAnnotations.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.cacheBuilder.buildCache(newBaseAnnotations, this.wrapped.getAnnotations(this.targetType));
    }

    private Map<IAnnotation, Collection<? extends IAnnotation>> buildOldBaseNewTargetCache(List<IAnnotation> newTargetAnnotations) {
        if (newTargetAnnotations.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.cacheBuilder.buildCache(this.wrapped.getAnnotations(this.baseType), newTargetAnnotations);
    }

    private Map<IAnnotation, Collection<? extends IAnnotation>> buildNewBaseNewTargetCache(List<IAnnotation> newBaseAnnotations, List<IAnnotation> newTargetAnnotations) {
        if (newBaseAnnotations.isEmpty() || newTargetAnnotations.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.cacheBuilder.buildCache(newBaseAnnotations, newTargetAnnotations);
    }

    private void mergeCaches(Map<IAnnotation, INLPDocument> baseCache, Map<IAnnotation, Collection<? extends IAnnotation>> additionalCache) {
        FastInRelationNLPDocument.mergeCaches(this.wrapped.getText(), baseCache, additionalCache);
    }

    private static Map<IAnnotation, INLPDocument> mergeCaches(String text, Map<IAnnotation, INLPDocument> baseCache, Map<IAnnotation, Collection<? extends IAnnotation>> additionalCache) {
        for (Map.Entry<IAnnotation, Collection<? extends IAnnotation>> additionalCacheEntry : additionalCache.entrySet()) {
            IAnnotation annotation = additionalCacheEntry.getKey();
            Collection<? extends IAnnotation> additionalStorage = additionalCacheEntry.getValue();
            INLPDocument storage = baseCache.get(annotation);
            if (storage == null) {
                storage = new NLPDocument(text);
            }
            storage = storage.withAnnotations(additionalStorage);
            baseCache.put(annotation, storage);
        }
        return baseCache;
    }

    @Override
    public <T extends IAnnotation> boolean hasAnnotations(Class<T> annotationClass) {
        return this.wrapped.hasAnnotations(annotationClass);
    }

    @Override
    public <T extends IAnnotation> List<T> getAnnotations(Class<T> annotationClass) {
        return this.wrapped.getAnnotations(annotationClass);
    }

    @Override
    public <T extends IAnnotation> List<T> getInRelationAnnotations(IAnnotation baseAnnotation, IAnnotationRelation relation, Class<T> annotationClass) {
        if (this.canBeCached(baseAnnotation, relation, annotationClass)) {
            return this.getCached(baseAnnotation, annotationClass);
        }
        return this.wrapped.getInRelationAnnotations(baseAnnotation, relation, annotationClass);
    }

    private <T extends IAnnotation> boolean canBeCached(IAnnotation baseAnnotation, IAnnotationRelation relation, Class<T> annotationClass) {
        return this.baseType.isInstance(baseAnnotation) && this.relation.equals(relation) && this.targetType.isAssignableFrom(annotationClass);
    }

    private <T extends IAnnotation> List<T> getCached(IAnnotation baseAnnotation, Class<T> annotationClass) {
        if (this.cache.containsKey(baseAnnotation)) {
            return this.cache.get(baseAnnotation).getAnnotations(annotationClass);
        }
        return Collections.emptyList();
    }

    @Override
    public String getText() {
        return this.wrapped.getText();
    }

    @Override
    public Set<Class<? extends IAnnotation>> getAnnotationsTypes() {
        return this.wrapped.getAnnotationsTypes();
    }
}

