/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import org.apache.commons.lang.Validate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.serializers.simple.SimpleSerializer;

@Root
@Order(elements={"start", "end", "annotatedText"})
public class Annotation
implements IAnnotation {
    private static final long serialVersionUID = 2118014455076970228L;
    @Element(name="start")
    protected final int start;
    @Element(name="end")
    protected final int end;
    protected final String annotatedText;

    @Element(name="annotatedText")
    private final String getNormalizedText() {
        return SimpleSerializer.getNormalizedString(this.annotatedText);
    }

    public Annotation(@Element(name="annotatedText") String text, @Element(name="start") int start, @Element(name="end") int end) {
        assert (text != null);
        Validate.isTrue((0 <= start ? 1 : 0) != 0, (String)"start should be non-negative.");
        Validate.isTrue((start <= end ? 1 : 0) != 0, (String)"start should less than or equals to end.");
        int length = text.length();
        Validate.isTrue((start <= length ? 1 : 0) != 0, (String)"start should be less than or equal to text length.");
        Validate.isTrue((end <= length ? 1 : 0) != 0, (String)"end should be less than or equal to text length.");
        this.start = start;
        this.end = end;
        this.annotatedText = text;
    }

    public Annotation(String text) {
        this(text, 0, text.length());
    }

    public Annotation(IAnnotation other) {
        this(other.getAnnotatedText(), other.getStart(), other.getEnd());
    }

    public Annotation(INLPDocument doc, int start, int end) {
        this(doc.getText(), start, end);
    }

    public Annotation(INLPDocument doc) {
        this(doc.getText());
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getAnnotatedText() {
        return this.annotatedText;
    }

    @Override
    public String getText() {
        return this.annotatedText.substring(this.start, this.end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAnnotation)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        IAnnotation other = (IAnnotation)obj;
        if (this.annotatedText == null ? other.getAnnotatedText() != null : !this.annotatedText.equals(other.getAnnotatedText())) {
            return false;
        }
        if (this.end != other.getEnd()) {
            return false;
        }
        return this.start == other.getStart();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [text=").append(this.getAnnotatedTextSnippet()).append(", start=").append(this.start).append(", end=").append(this.end).append("]");
        return builder.toString();
    }

    protected String getAnnotatedTextSnippet() {
        if (this.annotatedText.length() < 40) {
            return this.annotatedText;
        }
        return this.annotatedText.substring(0, 15) + "..." + this.annotatedText.substring(this.annotatedText.length() - 15);
    }
}

