/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.spelling;

import java.util.LinkedList;
import java.util.List;
import ru.ispras.modis.utils.collections.PackedStringSet;
import ru.ispras.texterra.core.nlp.annotators.spelling.AbstractSpellingSuggester;

public class RepeatedLetterContractingSuggester
extends AbstractSpellingSuggester {
    public RepeatedLetterContractingSuggester(PackedStringSet vocabulary) {
        super(vocabulary);
    }

    @Override
    protected boolean canBeCorrected(String incorrectWord) {
        return incorrectWord.matches(".*(.)\\1.*");
    }

    @Override
    protected List<String> getSuggestions(String incorrectWord) {
        if (incorrectWord.isEmpty()) {
            return new LinkedList<String>();
        }
        String initial = incorrectWord.substring(0, 1);
        LinkedList<String> variants = new LinkedList<String>();
        variants.add(initial);
        char lastChar = initial.charAt(0);
        int repeatCount = 0;
        for (int i = 1; i < incorrectWord.length(); ++i) {
            char currentChar = incorrectWord.charAt(i);
            int n = repeatCount = currentChar == lastChar ? repeatCount + 1 : 0;
            if (repeatCount >= 2) continue;
            LinkedList<String> subVariants = new LinkedList<String>();
            if (repeatCount == 1) {
                subVariants.addAll(variants);
            }
            for (String variant : variants) {
                subVariants.add(variant + currentChar);
            }
            variants = subVariants;
            lastChar = currentChar;
        }
        return variants;
    }
}

