/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.sentiment.subjectivity;

import java.util.Iterator;
import ru.ispras.ml.pipelines.SourceLabelPair;
import ru.ispras.texterra.core.nlp.annotators.IAnnotatorTrainer;
import ru.ispras.texterra.core.nlp.annotators.ml.pipelines.PredictionPipelineTrainer;
import ru.ispras.texterra.core.nlp.annotators.sentiment.subjectivity.SubjectivityDetector;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;

public class SubjectivityDetectorTrainer
implements IAnnotatorTrainer<SubjectivityDetector> {
    private final PredictionPipelineTrainer<INLPDocument, Boolean> predictorTrainer;

    public SubjectivityDetectorTrainer(PredictionPipelineTrainer<INLPDocument, Boolean> predictorTrainer) {
        this.predictorTrainer = predictorTrainer;
    }

    @Override
    public SubjectivityDetector train(Iterable<INLPDocument> documents) {
        SourcesLabelsIterable sourcesLabels = new SourcesLabelsIterable(documents);
        return new SubjectivityDetector(this.predictorTrainer.train(sourcesLabels));
    }

    private static class SourcesLabelsIterable
    implements Iterable<SourceLabelPair<INLPDocument, Boolean>> {
        private final Iterable<INLPDocument> documents;

        public SourcesLabelsIterable(Iterable<INLPDocument> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<SourceLabelPair<INLPDocument, Boolean>> iterator() {
            final Iterator<INLPDocument> documentsIt = this.documents.iterator();
            return new Iterator<SourceLabelPair<INLPDocument, Boolean>>(){

                @Override
                public boolean hasNext() {
                    return documentsIt.hasNext();
                }

                @Override
                public SourceLabelPair<INLPDocument, Boolean> next() {
                    INLPDocument doc = (INLPDocument)documentsIt.next();
                    boolean isSubjective = doc.hasAnnotations(SentimentSubjectivity.class);
                    return new SourceLabelPair((Object)doc, (Object)isSubjective);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

