/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.sentiment.polarity;

import java.util.Collection;
import java.util.Collections;
import ru.ispras.ml.pipelines.PredictionPipeline;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.SentimentPolarity;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;

public class PolarityDetector
implements ISerializableAnnotator<SentimentPolarity> {
    private static final long serialVersionUID = 4274304195661482361L;
    private final PredictionPipeline<INLPDocument, SentimentPolarity.Direction> predictor;

    protected PolarityDetector(PredictionPipeline<INLPDocument, SentimentPolarity.Direction> predictor) {
        this.predictor = predictor;
    }

    @Override
    public Collection<SentimentPolarity> annotate(INLPDocument doc) {
        if (doc.hasAnnotations(SentimentSubjectivity.class)) {
            SentimentPolarity.Direction direction = (SentimentPolarity.Direction)((Object)this.predictor.apply((Object)doc).getLabel());
            return Collections.singletonList(new SentimentPolarity(doc, direction));
        }
        return Collections.emptyList();
    }
}

