/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.pos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.ISerializableAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;

public class WithoutMorphCharactersPOSTagger
implements ISerializableAnnotator<POSToken> {
    private static final long serialVersionUID = 3774769005007015765L;

    @Override
    public Collection<POSToken> annotate(INLPDocument doc) {
        List<POSToken> annotations = doc.getAnnotations(POSToken.class);
        ArrayList<POSToken> result = new ArrayList<POSToken>(annotations.size());
        for (POSToken posToken : annotations) {
            result.add(this.convert(posToken));
        }
        return result;
    }

    private POSToken convert(POSToken posToken) {
        IMorphProperties posTag = (IMorphProperties)posToken.getValue();
        return new POSToken((IAnnotation)posToken, new MorphProperties(posTag.getPOSTag(), new IMorphCharacter[0]));
    }
}

