/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.spaceconverters;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.IntValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class BooleanToIntegerFeatureSpaceConverter
implements IFeatureExtractor<Map<Feature, IValue>> {
    private static final long serialVersionUID = 334375004329127779L;

    public Map<Feature, IValue> extract(Map<Feature, IValue> instance) {
        HashMap<Feature, IValue> featuresValues = new HashMap<Feature, IValue>();
        for (Map.Entry<Feature, IValue> featureAndValue : instance.entrySet()) {
            Feature feature = featureAndValue.getKey();
            IValue value = featureAndValue.getValue();
            if (!value.hasBoolean()) {
                featuresValues.put(feature, value);
                continue;
            }
            featuresValues.put(new Feature(feature.getName(), Type.INTEGER), (IValue)new IntValue(value.getBoolean() ? 1 : -1));
        }
        return featuresValues;
    }
}

