/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.FilteringThresholds;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ItemDatabase;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ItemDatabaseFactory;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.JaccardItemSet;

public final class JaccardItemMiner {
    private final double jaccardThreshold;
    private final FilteringThresholds filteringThresholds;

    public JaccardItemMiner(double jaccardThreshold) {
        this(jaccardThreshold, new FilteringThresholds());
    }

    public JaccardItemMiner(double jaccardThreshold, FilteringThresholds filteringThresholds) {
        this.jaccardThreshold = jaccardThreshold;
        this.filteringThresholds = filteringThresholds;
    }

    public <T> Collection<JaccardItemSet<T>> mineFrequentItems(Collection<Set<T>> itemSets) {
        ItemDatabase<T> db = new ItemDatabaseFactory().create(itemSets, this.filteringThresholds);
        ForkJoinPool pool = new ForkJoinPool();
        Collection result = ((Collection)pool.invoke(new JaccardItemSelector<T>(db, this.jaccardThreshold))).stream().filter(itemsWithJaccard -> itemsWithJaccard.length() > 1).collect(Collectors.toList());
        pool.shutdownNow();
        return result;
    }

    private static final class JaccardItemSelector<T>
    extends RecursiveTask<Collection<JaccardItemSet<T>>> {
        private static final long serialVersionUID = 5123508797801220907L;
        private final ItemDatabase<T> db;
        private final double jaccardThreshold;

        public JaccardItemSelector(ItemDatabase<T> db, double jaccardThreshold) {
            this.db = db;
            this.jaccardThreshold = jaccardThreshold;
        }

        @Override
        protected Collection<JaccardItemSet<T>> compute() {
            if (this.db.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result = new ArrayList();
            LinkedList<ItemDatabase<T>> subTasks = new LinkedList<ItemDatabase<T>>();
            subTasks.add(this.db);
            ArrayList forked = new ArrayList();
            while (!subTasks.isEmpty()) {
                ItemDatabase currentDb = (ItemDatabase)subTasks.pop();
                while (!subTasks.isEmpty()) {
                    ItemDatabase toFork = (ItemDatabase)subTasks.pop();
                    forked.add(new JaccardItemSelector<T>(toFork, this.jaccardThreshold).fork());
                }
                JaccardItemSet itemsWithJaccard = currentDb.getJaccardItemSet();
                if (itemsWithJaccard.getJaccard() >= this.jaccardThreshold) {
                    result.add(itemsWithJaccard);
                    this.addNonEmptyDb(subTasks, currentDb.reducedOnFirstItem());
                }
                this.addNonEmptyDb(subTasks, currentDb.withoutFirstItem());
            }
            forked.forEach(task -> result.addAll((Collection)task.join()));
            return result;
        }

        private void addNonEmptyDb(LinkedList<ItemDatabase<T>> subTasks, ItemDatabase<T> db) {
            if (!db.isEmpty()) {
                subTasks.add(db);
            }
        }
    }
}

