/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.FilteringThresholds;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ICompositeFeatureExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.IFeatureExtractorsMergeStrategy;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.JaccardItemMiner;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.JaccardItemSet;

public final class JIMFeatureSelectorFactory<L, T>
implements Function<ILabeledDataset<L>, IFeatureExtractor<Map<Feature, IValue>>> {
    private final double jaccardThreshold;
    private final FilteringThresholds filteringThresholds;
    private final BiFunction<L, L, Double> jaccardRatioThreshold;
    private final BiFunction<Feature, IValue, Set<T>> featureMapper;
    private final Function<Set<T>, ICompositeFeatureExtractor> featureResolver;
    private final IFeatureExtractorsMergeStrategy mergeStrategy;

    public JIMFeatureSelectorFactory(double jaccardThreshold, FilteringThresholds filteringThresholds, BiFunction<L, L, Double> jaccardRatioThreshold, BiFunction<Feature, IValue, Set<T>> featureMapper, Function<Set<T>, ICompositeFeatureExtractor> featureResolver, IFeatureExtractorsMergeStrategy mergeStrategy) {
        this.jaccardThreshold = jaccardThreshold;
        this.filteringThresholds = filteringThresholds;
        this.jaccardRatioThreshold = jaccardRatioThreshold;
        this.featureMapper = featureMapper;
        this.featureResolver = featureResolver;
        this.mergeStrategy = mergeStrategy;
    }

    @Override
    public IFeatureExtractor<Map<Feature, IValue>> apply(ILabeledDataset<L> dataset) {
        JaccardItemMiner jaccardMiner = new JaccardItemMiner(this.jaccardThreshold, this.filteringThresholds);
        Map<Object, Collection> itemSets = dataset.stream().collect(Collectors.groupingBy(instance -> instance.getLabel(), Collectors.mapping(IInstance::getFeaturesValues, Collectors.mapping(instance -> this.mapToItems((Map<Feature, IValue>)instance), Collectors.collectingAndThen(Collectors.toList(), list -> jaccardMiner.mineFrequentItems(list))))));
        List<ICompositeFeatureExtractor> composite = this.createCompositeFeatureExtractors(itemSets);
        return this.mergeStrategy.merge((IFeatureExtractor<Map<Feature, IValue>>)(IFeatureExtractor & Serializable)fv -> fv, composite);
    }

    private Set<T> mapToItems(Map<Feature, IValue> instance) {
        return instance.entrySet().stream().flatMap(e -> this.featureMapper.apply((Feature)e.getKey(), (IValue)e.getValue()).stream()).distinct().collect(Collectors.toSet());
    }

    private List<ICompositeFeatureExtractor> createCompositeFeatureExtractors(Map<L, Collection<JaccardItemSet<T>>> itemSetsByLabel) {
        ArrayList<L> labels = new ArrayList<L>(itemSetsByLabel.keySet());
        Map<Object, Map> itemSets = itemSetsByLabel.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> ((Collection)e.getValue()).stream().collect(Collectors.toMap(itemSet -> itemSet.getItems(), itemSet -> itemSet.getJaccard()))));
        ArrayList<ICompositeFeatureExtractor> result = new ArrayList<ICompositeFeatureExtractor>();
        for (int i = 0; i < labels.size(); ++i) {
            Map one = itemSets.get(labels.get(i));
            for (int j = i + 1; j < labels.size(); ++j) {
                Map another = itemSets.get(labels.get(j));
                result.addAll(this.computeFeatureExtractors(one, another, this.jaccardRatioThreshold.apply(labels.get(i), labels.get(j))));
                result.addAll(this.computeFeatureExtractors(another, one, this.jaccardRatioThreshold.apply(labels.get(j), labels.get(i))));
            }
        }
        return result;
    }

    private Collection<ICompositeFeatureExtractor> computeFeatureExtractors(Map<Set<T>, Double> one, Map<Set<T>, Double> another, Double threshold) {
        ArrayList<ICompositeFeatureExtractor> result = new ArrayList<ICompositeFeatureExtractor>();
        for (Map.Entry<Set<T>, Double> e : one.entrySet()) {
            if (another.containsKey(e.getKey()) && !(e.getValue() / another.get(e.getKey()) >= threshold)) continue;
            result.add(this.featureResolver.apply(e.getKey()));
        }
        return result;
    }
}

