/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

final class ItemTransactions<T>
implements Serializable {
    private static final long serialVersionUID = 1064611177966166680L;
    private final T item;
    private final List<Integer> cover;
    private final List<Integer> extraSet;

    public ItemTransactions(T item, List<Integer> cover, List<Integer> extraSet) {
        this.item = item;
        this.cover = cover;
        this.extraSet = extraSet;
    }

    public ItemTransactions<T> getMergedWith(ItemTransactions<T> another) {
        return new ItemTransactions<T>(this.item, this.getCoverIntersectionWith(another.cover), this.getExtraSetWithout(another.extraSet));
    }

    private List<Integer> getCoverIntersectionWith(List<Integer> anotherCover) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < this.cover.size() && j < anotherCover.size()) {
            int value = this.cover.get(i);
            if (value == anotherCover.get(j)) {
                result.add(value);
                ++i;
                ++j;
                continue;
            }
            if (value < anotherCover.get(j)) {
                ++i;
                continue;
            }
            ++j;
        }
        return result;
    }

    private List<Integer> getExtraSetWithout(List<Integer> anotherExtraSet) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        int j = 0;
        while (i < this.extraSet.size() && j < anotherExtraSet.size()) {
            int value = this.extraSet.get(i);
            if (value == anotherExtraSet.get(j)) {
                ++i;
                ++j;
                continue;
            }
            if (value < anotherExtraSet.get(j)) {
                result.add(value);
                ++i;
                continue;
            }
            ++j;
        }
        result.addAll(this.extraSet.subList(i, this.extraSet.size()));
        return result;
    }

    public int getExtraSetSize() {
        return this.extraSet.size();
    }

    public int getCoverSize() {
        return this.cover.size();
    }

    public T getItem() {
        return this.item;
    }

    public boolean isEmptyCover() {
        return this.cover.isEmpty();
    }
}

