/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.ItemTransactions;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim.JaccardItemSet;

final class ItemDatabase<T>
implements Serializable {
    private static final long serialVersionUID = 4312259780058421072L;
    private final Set<T> prefix;
    private final int prefixExtent;
    private final List<ItemTransactions<T>> itemTransactions;

    public ItemDatabase(List<ItemTransactions<T>> itemTransactions) {
        this(Collections.emptySet(), 0, itemTransactions);
    }

    private ItemDatabase(Set<T> prefix, int prefixExtent, List<ItemTransactions<T>> itemTransactions) {
        this.prefix = prefix;
        this.prefixExtent = prefixExtent;
        this.itemTransactions = itemTransactions;
    }

    public ItemDatabase<T> withoutFirstItem() {
        return new ItemDatabase<T>(new HashSet<T>(this.prefix), this.prefixExtent, this.itemTransactions.stream().skip(1L).collect(Collectors.toList()));
    }

    public ItemDatabase<T> reducedOnFirstItem() {
        if (this.itemTransactions.isEmpty()) {
            throw new IllegalStateException();
        }
        ItemTransactions first = this.itemTransactions.get(0);
        return new ItemDatabase<T>(this.recomputePrefixWithFirstItem(), this.computeExtentForFirst(), this.itemTransactions.stream().skip(1L).map(tr -> tr.getMergedWith(first)).filter(tr -> !tr.isEmptyCover()).collect(Collectors.toList()));
    }

    private Set<T> recomputePrefixWithFirstItem() {
        return Stream.concat(this.prefix.stream(), Stream.of(this.itemTransactions.get(0).getItem())).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.itemTransactions.isEmpty();
    }

    public JaccardItemSet<T> getJaccardItemSet() {
        if (this.itemTransactions.isEmpty()) {
            throw new IllegalStateException();
        }
        double jaccard = this.computeJaccardForFirst();
        return new JaccardItemSet<T>(this.recomputePrefixWithFirstItem(), jaccard);
    }

    private double computeJaccardForFirst() {
        return (double)this.itemTransactions.get(0).getCoverSize() / (double)this.computeExtentForFirst();
    }

    private int computeExtentForFirst() {
        ItemTransactions<T> first = this.itemTransactions.get(0);
        return this.prefixExtent + first.getExtraSetSize();
    }

    public String toString() {
        return "ItemDatabase: [prefix=" + this.prefix + ", transactionSize=" + this.itemTransactions.size() + "]";
    }
}

