/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

public final class FilteringThresholds {
    private final int min;
    private final int max;
    private final double minProportion;
    private final double maxProportion;

    public FilteringThresholds() {
        this.min = 0;
        this.max = Integer.MAX_VALUE;
        this.minProportion = 0.0;
        this.maxProportion = 1.0;
    }

    private FilteringThresholds(int min, int max, double minProportion, double maxProportion) {
        this.min = min;
        this.max = max;
        this.minProportion = minProportion;
        this.maxProportion = maxProportion;
    }

    public FilteringThresholds withMin(int newMin) {
        return new FilteringThresholds(newMin, this.max, this.minProportion, this.maxProportion);
    }

    public FilteringThresholds withMax(int newMax) {
        return new FilteringThresholds(this.min, newMax, this.minProportion, this.maxProportion);
    }

    public FilteringThresholds withMinProportion(double newMinProportion) {
        return new FilteringThresholds(this.min, this.max, newMinProportion, this.maxProportion);
    }

    public FilteringThresholds withMaxProportion(double newMaxProportion) {
        return new FilteringThresholds(this.min, this.max, this.minProportion, newMaxProportion);
    }

    public int getMinThreshold(int total) {
        return Math.max(this.min, (int)((double)total * this.minProportion));
    }

    public int getMaxThreshold(int total) {
        return Math.min(this.max, (int)((double)total * this.maxProportion));
    }
}

