/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.jim;

import java.util.Map;
import java.util.function.Function;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.classification.IConfidenceClassifierTrainer;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.Instance;
import ru.ispras.ml.datamodel.LabelledInstance;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public final class FeatureSelectingTrainer<L>
implements IConfidenceClassifierTrainer<L> {
    private static final long serialVersionUID = -1139623191323609166L;
    private final IConfidenceClassifierTrainer<L> wrapped;
    private final Function<ILabeledDataset<L>, IFeatureExtractor<Map<Feature, IValue>>> featureSelectorFactory;
    private IFeatureExtractor<Map<Feature, IValue>> modelFeatureExtractor = null;

    public FeatureSelectingTrainer(IConfidenceClassifierTrainer<L> wrapped, Function<ILabeledDataset<L>, IFeatureExtractor<Map<Feature, IValue>>> featureSelector) {
        this.wrapped = wrapped;
        this.featureSelectorFactory = featureSelector;
    }

    public void train(ILabelledInstance<L> precedent) throws TrainingException {
        throw new UnsupportedOperationException();
    }

    public void train(ILabeledDataset<L> data) throws TrainingException {
        this.modelFeatureExtractor = this.featureSelectorFactory.apply(data);
        this.wrapped.train(() -> data.stream().map(labeled -> new LabelledInstance((IInstance)new Instance(labeled.getId(), this.modelFeatureExtractor.extract((Object)labeled.getFeaturesValues())), labeled.getLabel())));
    }

    public IConfidenceClassifier<L> getPredictor() {
        return new FeatureSelectingConfidenceClassifier(this.modelFeatureExtractor, this.wrapped.getPredictor());
    }

    public static final class FeatureSelectingConfidenceClassifier<L>
    implements IConfidenceClassifier<L> {
        private static final long serialVersionUID = 5640680486167825850L;
        private final IFeatureExtractor<Map<Feature, IValue>> featureExtractor;
        private final IConfidenceClassifier<L> classifier;

        public FeatureSelectingConfidenceClassifier(IFeatureExtractor<Map<Feature, IValue>> featureExtractor, IConfidenceClassifier<L> classifier) {
            this.featureExtractor = featureExtractor;
            this.classifier = classifier;
        }

        public ConfidenceClassificationResult<L> predict(IInstance instance) throws ClassificationException {
            return this.classifier.predict((IInstance)new Instance(instance.getId(), this.featureExtractor.extract((Object)instance.getFeaturesValues())));
        }
    }
}

