/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.predicates;

import java.io.Serializable;
import org.apache.commons.collections15.Predicate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class IsAtContainerStartPredicate<A extends IAnnotation, C extends IAnnotation>
implements Predicate<NLPDocumentWithAnnotation<A>>,
Serializable {
    private static final long serialVersionUID = 6949874122794412794L;
    private final Class<C> containerType;

    public IsAtContainerStartPredicate(Class<C> containerType) {
        this.containerType = containerType;
    }

    public boolean evaluate(NLPDocumentWithAnnotation<A> documentWithAnnotation) {
        INLPDocument document = documentWithAnnotation.getDocument();
        A annotation = documentWithAnnotation.getAnnotation();
        C container = NLPDocumentHelper.getContainerAnnotation(document, annotation, this.containerType);
        return annotation.getStart() == container.getStart();
    }
}

