/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.contextextractors.IContextExtractor;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors.windowextractors.IWindowExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class WindowContextExtractor<A extends IAnnotation>
implements IContextExtractor<NLPDocumentWithAnnotation<A>, A> {
    private static final long serialVersionUID = 5738463475384787588L;
    private static final Comparator<IAnnotation> comparator = new INLPDocument.AnnotationsComparator();
    private final IContextExtractor<NLPDocumentWithAnnotation<A>, A> wrapped;
    private final IWindowExtractor<A> windowExtractor;

    public WindowContextExtractor(IContextExtractor<NLPDocumentWithAnnotation<A>, A> wrapped, IWindowExtractor<A> windowExtractor) {
        this.wrapped = wrapped;
        this.windowExtractor = windowExtractor;
    }

    @Override
    public List<A> extract(NLPDocumentWithAnnotation<A> document) {
        A annotation = document.getAnnotation();
        List<A> annotations = this.wrapped.extract(document);
        int index = this.getIndex(annotations, annotation);
        return this.windowExtractor.extract(annotations, index);
    }

    private int getIndex(List<A> annotations, A baseAnnotation) {
        int result = Collections.binarySearch(annotations, baseAnnotation, comparator);
        if (result < 0) {
            throw new IllegalArgumentException(String.format("%s is not found.", baseAnnotation));
        }
        return result;
    }
}

