/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents.contextextractors;

import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.contextextractors.IContextExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelation;

public final class InContainerAnnotationContextExtractor<BA extends IAnnotation, CA extends IAnnotation>
implements IContextExtractor<NLPDocumentWithAnnotation<BA>, BA> {
    private static final long serialVersionUID = -2404743773705362025L;
    private static final ContainsAnnotationRelation CONTAINS_RELATION = new ContainsAnnotationRelation();
    private final Class<BA> baseType;
    private final Class<CA> containerType;

    public InContainerAnnotationContextExtractor(Class<BA> baseType, Class<CA> containerType) {
        this.baseType = baseType;
        this.containerType = containerType;
    }

    @Override
    public List<BA> extract(NLPDocumentWithAnnotation<BA> documentWithAnnotation) {
        INLPDocument document = documentWithAnnotation.getDocument();
        BA annotation = documentWithAnnotation.getAnnotation();
        CA container = NLPDocumentHelper.getContainerAnnotation(document, annotation, this.containerType);
        return document.getInRelationAnnotations((IAnnotation)container, CONTAINS_RELATION, this.baseType);
    }
}

