/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;

public final class PositionInContainerFeatureExtractor<A extends IAnnotation>
implements IFeatureExtractor<NLPDocumentWithAnnotation<A>> {
    private static final long serialVersionUID = 6619779994182101740L;
    private static final IAnnotationRelation CONTAINS_RELATION = new ContainsAnnotationRelation();
    private final Map<Feature, BiPredicate<Integer, Integer>> positionSizePredicates;
    private final Class<? extends IAnnotation> containerType;
    private final Class<A> targetType;

    public PositionInContainerFeatureExtractor(Map<Feature, BiPredicate<Integer, Integer>> positionSizePredicates, Class<? extends IAnnotation> containerType, Class<A> targetType) {
        this.positionSizePredicates = new HashMap<Feature, BiPredicate<Integer, Integer>>(positionSizePredicates);
        this.containerType = containerType;
        this.targetType = targetType;
    }

    public Map<Feature, IValue> extract(NLPDocumentWithAnnotation<A> docWithAnnotation) {
        IAnnotation container = NLPDocumentHelper.getContainerAnnotation(docWithAnnotation.getDocument(), docWithAnnotation.getAnnotation(), this.containerType);
        List<A> targetAnnotations = docWithAnnotation.getDocument().getInRelationAnnotations(container, CONTAINS_RELATION, this.targetType);
        int position = Collections.binarySearch(targetAnnotations, docWithAnnotation.getAnnotation(), NLPDocument.annotationsComparator);
        if (position < 0) {
            throw new IllegalStateException();
        }
        int size = targetAnnotations.size();
        return this.positionSizePredicates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> BooleanValue.of((boolean)((BiPredicate)e.getValue()).test(position, size))));
    }
}

