/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.ml.featureextractors.documents;

import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentHelper;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;

public final class CoincidingAnnotationFeatureExtractor<SA extends IAnnotation, TA extends IAnnotation>
implements IFeatureExtractor<NLPDocumentWithAnnotation<SA>> {
    private static final long serialVersionUID = -1188681494479033617L;
    private final Class<TA> targetType;
    private final IFeatureExtractor<NLPDocumentWithAnnotation<TA>> wrapped;

    public CoincidingAnnotationFeatureExtractor(Class<TA> targetType, IFeatureExtractor<NLPDocumentWithAnnotation<TA>> wrapped) {
        this.targetType = targetType;
        this.wrapped = wrapped;
    }

    public Map<Feature, IValue> extract(NLPDocumentWithAnnotation<SA> documentWithAnnotation) {
        INLPDocument document = documentWithAnnotation.getDocument();
        SA annotation = documentWithAnnotation.getAnnotation();
        TA target = NLPDocumentHelper.getCoincidingAnnotation(document, annotation, this.targetType);
        return this.wrapped.extract(new NLPDocumentWithAnnotation<TA>(document, target));
    }
}

